package ru.yandex.autotests.direct.fakebsproxy.rest.providers;

import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.HashMap;

@Provider
public class RequestFilter implements ContainerRequestFilter{

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        FakeBSProxyLogBean logBean = new FakeBSProxyLogBean().withHeaders(new HashMap<>());
        //Here we loose duplicated headers values, but i guess it's OK, because we can't read from Mongo MultivaluedMap
        requestContext.getHeaders().forEach((s, strings) -> logBean.getHeaders().put(s, strings.get(0)));
        requestContext.setProperty(FakeBSProxyLogBean.class.getName()
                , logBean.withRequestTime(System.currentTimeMillis()));
    }
}
