package ru.yandex.autotests.direct.fakebsproxy.rest.resources;

import java.io.IOException;
import java.net.URISyntaxException;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.moderate.Request;
import ru.yandex.autotests.direct.fakebsproxy.beans.performancerejectedoffers.PerformanceRejectedOffersResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.PpcCampGetGoalsRequestBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppcfeedtobannerland.PpcFeedToBannerlandRequestBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppcfeedtobannerland.PpcFeedToBannerlandResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.transport.mobile.TransportMobileResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.updatestorecontent.UpdateStoreContentMobileRequestBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.updatestorecontent.UpdateStoreContentMobileResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeBSProxyClientDataService;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeBSProxyMobileService;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeBSProxyModerateService;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeBSProxyPerformanceRejectedOffersService;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeProxyPpcCampGetGoals;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeProxyPpcFeedToBannerlandService;
import ru.yandex.autotests.direct.fakebsproxy.service.FakeProxyUpdateStoreContentService;

@Component
@Path("proxy")
public class FakeBSProxyRestService {

    private static final Logger logger = LoggerFactory.getLogger(FakeBSProxyRestService.class);

    @Autowired
    private FakeBSProxyMobileService fakeBSProxyMobileService;

    @Autowired
    private FakeProxyUpdateStoreContentService fakeBSProxyUpdateStoreContentService;

    @Autowired
    private FakeBSProxyClientDataService fakeBSProxyClientDataService;

    @Autowired
    private FakeBSProxyPerformanceRejectedOffersService fakeBSProxyPerformanceRejectedOffersService;

    @Autowired
    private FakeProxyPpcFeedToBannerlandService fakeProxyPpcFeedToBannerlandService;

    @Autowired
    private FakeBSProxyModerateService fakeBSProxyModerateService;

    @Autowired
    private FakeProxyPpcCampGetGoals fakeProxyPpcCampGetGoals;

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/mobile")
    public TransportMobileResponseBean handleMobileTransportRequest(@Context ContainerRequestContext context
            , String jsonEntity) throws IOException
    {
        return fakeBSProxyMobileService.handleMobileRequest(
                (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName())
                , jsonEntity);
    }

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/moderate")
    public String handleModerateRequest(@Context ContainerRequestContext context,
            String jsonEntity) throws IOException
    {
        logger.info("Moderate request: {}", jsonEntity);
        Request request = new Request().fromString(jsonEntity);
        String response;
        try {
            switch (request.getMethod()) {
                case PUT_RECORDS:
                    response = fakeBSProxyModerateService.handlePutRecordsRequest(
                            (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()), request);
                    break;
                case GET_DIRECT_MAGIC_QUEUE:
                    response = fakeBSProxyModerateService.handleGetDirectMagicQueueRequest(
                            (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()), request);
                    break;
                case PROCESS_MAGIC_QUEUE:
                    response = fakeBSProxyModerateService.handleProcessMagicQueueRequest(
                            (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()), request);
                    break;
                default:
                    throw new WebApplicationException("Unknown method in request: " + request.getMethod(), 500);
            }
        } catch (Exception e) {
            logger.error("got exception in Moderate controller", e);
            throw new WebApplicationException(e);
        }
        logger.info("Moderate response: {}", response);
        return response;
    }

    @POST
    @Consumes(MediaType.TEXT_XML)
    @Produces(MediaType.TEXT_XML)
    @Path("/bs-client-data")
    public String handleBsClientDataTransportRequest(@Context ContainerRequestContext context
            , String xml) throws IOException
    {
        return fakeBSProxyClientDataService.handleRequest(
                (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()),
                xml);
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/perfomance-rejected-offers")
    public PerformanceRejectedOffersResponseBean handlePerfomanceRejectedOffersRequest(
            @Context ContainerRequestContext context, @QueryParam("timestamp") String timestamp)
            throws IOException, URISyntaxException
    {
        return fakeBSProxyPerformanceRejectedOffersService.handleRequest(
                (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()),
                timestamp);
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/mobile-store-data")
    public UpdateStoreContentMobileResponseBean getUpdateStoreContentRequest(@Context ContainerRequestContext context
            , @QueryParam("app_id") String appId
            , @QueryParam("content_type") String contentType
            , @QueryParam("country") String country
            , @QueryParam("store") String store)
    {
        return fakeBSProxyUpdateStoreContentService
                .handleUpdateStoreContentRequest(
                        (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName())
                        , new UpdateStoreContentMobileRequestBean()
                                .withAppId(appId)
                                .withContentType(contentType)
                                .withCountry(country)
                                .withStore(store));
    }

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("/feed-to-bannerland")
    public PpcFeedToBannerlandResponseBean handlePpcFeedToBannerLandRequest(@Context ContainerRequestContext context
            , @QueryParam("cmd") String cmd
            , @QueryParam("max_file_size") Long maxFileSize
            , @QueryParam("max_file_size_type") String maxFileSizeType
            , @QueryParam("url") String url) throws IOException, URISyntaxException
    {
        return fakeProxyPpcFeedToBannerlandService.handleRequest(
                (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()),
                new PpcFeedToBannerlandRequestBean()
                        .withCmd(cmd)
                        .withMaxFileSize(maxFileSize)
                        .withMaxFileSizeType(maxFileSizeType)
                        .withUrl(url)
        );
    }

    @GET
    @Produces(MediaType.TEXT_PLAIN)
    @Path("/export/export_direct_goal_stat.cgi")
    public String handlePpcCampGetGoalsRequest(@Context ContainerRequestContext context
            , @QueryParam("date_from") String dateFrom
            , @QueryParam("date_to") String dateTo) throws IOException, URISyntaxException
    {
        return fakeProxyPpcCampGetGoals.handlePpcCampGetGoalsRequest(
                (FakeBSProxyLogBean) context.getProperty(FakeBSProxyLogBean.class.getName()),
                new PpcCampGetGoalsRequestBean()
                        .withDateFrom(dateFrom)
                        .withDateTo(dateTo)
        );
    }
}
