package ru.yandex.autotests.direct.fakebsproxy.service;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.transport.mobile.TransportMobileResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.transport.mobile.TransportMobileResponseItemBean;
import ru.yandex.autotests.direct.fakebsproxy.dao.FakeBSProxyLogBeanMongoHelper;
import ru.yandex.autotests.direct.fakebsproxy.service.utils.FakeBsProxyHttpClient;

import javax.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by buhter on 29/07/15.
 */
@Service
public class FakeBSProxyMobileService {

    public static final String REQUEST_UUID_HEADER_NAME = "Request-uuid";
    private static final FakeBSProxyLogBeanMongoHelper MONGO_HELPER = new FakeBSProxyLogBeanMongoHelper();

    public TransportMobileResponseBean handleMobileRequest(FakeBSProxyLogBean logBean, String jsonEntity)
            throws IOException {
        List<Object> requestMobileAppIdList = getRequestBeanMobileAppIdList(jsonEntity);
        if (requestMobileAppIdList.size() > 0) {
            FakeBSProxyLogBean preloadedLogBean = MONGO_HELPER
                    .getFakeBSProxyLogBeanById(requestMobileAppIdList.get(0));
            if (preloadedLogBean != null) {
                preloadedLogBean.setHeaders(logBean.getHeaders());
                preloadedLogBean.setRequestTime(logBean.getRequestTime());
                preloadedLogBean.setRequestUUID(logBean.getRequestUUID());
                MONGO_HELPER.deleteFakeBSProxyLogBeansById(requestMobileAppIdList.get(0));
                logBean = new FakeBSProxyLogBean(preloadedLogBean);
            }
        }

        logBean.withObjectIds(requestMobileAppIdList)
                .withRequestEntity(jsonEntity)
                .withRequestUUID(logBean.getHeaders().get(REQUEST_UUID_HEADER_NAME));

        if (logBean.getResponseEntity() == null) {
            if (logBean.getProxyURI() != null) {
                logBean.setResponseEntity(
                        new FakeBsProxyHttpClient().post(logBean.getProxyURI(), jsonEntity, MediaType.APPLICATION_JSON)
                );
            } else {
                logBean.setResponseEntity(getDefaultResponseEntity(jsonEntity).toString());
            }
        }

        MONGO_HELPER.addMongoBean(logBean);
        return new TransportMobileResponseBean().fromString(logBean.getResponseEntity());
    }

    public static TransportMobileResponseBean getDefaultResponseEntity(String jsonEntity) {
        return getDefaultResponseEntity(getRequestBeanMobileAppIdList(jsonEntity));
    }

    public static TransportMobileResponseBean getDefaultResponseEntity(List<Object> mobileAppIdList) {
        TransportMobileResponseBean responseBean = new TransportMobileResponseBean();
        responseBean.setResultItems(new ArrayList<>());

        mobileAppIdList.forEach(mobileAppId -> {
            TransportMobileResponseItemBean responseItemBean = new TransportMobileResponseItemBean();
            responseItemBean.setMobileAppId((Long) mobileAppId);
            responseBean.getResultItems().add(responseItemBean);
        });
        return responseBean;
    }

    public static List getRequestBeanList(String jsonEntity) {
        return new Gson().fromJson(jsonEntity, List.class);
    }

    public static List getRequestBeanMobileAppIdList(String jsonEntity) {
        return getRequestBeanMobileAppIdList(getRequestBeanList(jsonEntity));
    }

    public static List getRequestBeanMobileAppIdList(List<LinkedTreeMap> requestBeanList) {
        return requestBeanList.stream().map(linkedTreeMap
                -> ((Double) linkedTreeMap.get("mobile_app_id")).longValue()).collect(Collectors.toList());
    }
}
