package ru.yandex.autotests.direct.fakebsproxy.service;

import org.apache.http.client.utils.URIBuilder;
import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.performancerejectedoffers.PerformanceRejectedOffersResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.dao.FakeBSProxyLogBeanMongoHelper;
import ru.yandex.autotests.direct.fakebsproxy.service.utils.FakeBsProxyHttpClient;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;

/**
 * Created by buhter on 15/04/16.
 */
@Service
public class FakeBSProxyPerformanceRejectedOffersService {
    private static final FakeBSProxyLogBeanMongoHelper MONGO_HELPER = new FakeBSProxyLogBeanMongoHelper();

    public PerformanceRejectedOffersResponseBean handleRequest(FakeBSProxyLogBean logBean, String timestamp)
            throws IOException, URISyntaxException {

        FakeBSProxyLogBean preloadedLogBean = MONGO_HELPER.getFakeBSProxyLogBeanById(Long.valueOf(timestamp));
        if (preloadedLogBean == null) {
            return null;
        }

        if (preloadedLogBean.getResponseEntity() == null) {
            if (preloadedLogBean.getProxyURI() != null) {
                HashMap<String, String> parameters = new HashMap<>();
                parameters.put("timestamp", timestamp);
                preloadedLogBean.setResponseEntity(
                        new FakeBsProxyHttpClient().get(new URIBuilder(logBean.getProxyURI())
                                .addParameter("timestamp", timestamp).build())
                );
            } else {
                preloadedLogBean.setResponseEntity("No predefined response or proxy url specified");
            }
        }

        preloadedLogBean.withHeaders(logBean.getHeaders())
                .withRequestTime(logBean.getRequestTime())
                .withRequestUUID(logBean.getRequestUUID())
                .withObjectIds(Arrays.asList(timestamp))
                .withRequestEntity(timestamp);

        MONGO_HELPER.addMongoBean(preloadedLogBean);
        return new PerformanceRejectedOffersResponseBean().fromString(preloadedLogBean.getResponseEntity());
    }
}
