package ru.yandex.autotests.direct.fakebsproxy.service;

import org.springframework.stereotype.Service;

import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.PpcCampGetGoalsRequestBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppccampgetgoals.PpcCampGetGoalsResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.dao.FakeBSProxyLogBeanMongoHelper;

@Service
public class FakeProxyPpcCampGetGoals {

    private static final FakeBSProxyLogBeanMongoHelper MONGO_HELPER = new FakeBSProxyLogBeanMongoHelper();

    public String handlePpcCampGetGoalsRequest(FakeBSProxyLogBean logBean
            , PpcCampGetGoalsRequestBean requestBean) {

        FakeBSProxyLogBean preloadedLogBean = MONGO_HELPER.getFakeBSProxyLogBeanById( requestBean.getDateFrom()
                + ":" + requestBean.getDateTo());

        logBean = new FakeBSProxyLogBean(preloadedLogBean
                .withHeaders(logBean.getHeaders())
                .withRequestEntity(requestBean.toString())
                .withRequestUUID(requestBean.toString() + System.currentTimeMillis()));

        if (logBean.getResponseEntity() == null) {
            logBean.setResponseEntity("Couldn't resolve response");
        }

        MONGO_HELPER.addMongoBean(logBean);
        return logBean.getResponseEntity();
    }
}
