package ru.yandex.autotests.direct.fakebsproxy.service;

import com.google.gson.Gson;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.fakebsproxy.beans.ErrorItemBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppcfeedtobannerland.PpcFeedToBannerlandRequestBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.ppcfeedtobannerland.PpcFeedToBannerlandResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.dao.FakeBSProxyLogBeanMongoHelper;
import ru.yandex.autotests.direct.fakebsproxy.service.utils.FakeBsProxyHttpClient;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * Created by buhter on 15/04/16.
 */
@Service
public class FakeProxyPpcFeedToBannerlandService {
    private static final FakeBSProxyLogBeanMongoHelper MONGO_HELPER = new FakeBSProxyLogBeanMongoHelper();
    private static final Gson GSON = new Gson();

    public PpcFeedToBannerlandResponseBean handleRequest(FakeBSProxyLogBean logBean
            , PpcFeedToBannerlandRequestBean requestBean)
            throws IOException, URISyntaxException {

        FakeBSProxyLogBean preloadedLogBean = MONGO_HELPER.getFakeBSProxyLogBeanById(requestBean.getUrl());
        if (preloadedLogBean == null) {
            PpcFeedToBannerlandResponseBean responseBean = new PpcFeedToBannerlandResponseBean()
                    .withCategories(new ArrayList<>())
                    .withErrors(Arrays.asList(new ErrorItemBean().withCode(2000).withMessage(requestBean.getCmd())))
                    .withFileData(requestBean.getUrl())
                    .withWarnings(Arrays.asList(new ErrorItemBean().withCode(1000).withMessage("warn")));
            preloadedLogBean = new FakeBSProxyLogBean().withResponseEntity(GSON.toJson(responseBean));
        } else {
            if (preloadedLogBean.getResponseEntity() == null) {
                if (preloadedLogBean.getProxyURI() != null) {
                    preloadedLogBean.setResponseEntity(
                            new FakeBsProxyHttpClient().get(new URIBuilder(logBean.getProxyURI())
                                    .addParameter(
                                            PpcFeedToBannerlandRequestBean.CMD,
                                            requestBean.getCmd())
                                    .addParameter(
                                            PpcFeedToBannerlandRequestBean.MAX_FILE_SIZE,
                                            requestBean.getMaxFileSize().toString())
                                    .addParameter(
                                            PpcFeedToBannerlandRequestBean.MAX_FILE_SIZE_TYPE,
                                            requestBean.getMaxFileSizeType())
                                    .addParameter(
                                            PpcFeedToBannerlandRequestBean.URL,
                                            requestBean.getUrl())
                                    .build())
                    );
                } else {
                    preloadedLogBean.setResponseEntity("No predefined response or proxy url specified");
                }
            }
        }

        preloadedLogBean.withHeaders(logBean.getHeaders())
                .withRequestTime(logBean.getRequestTime())
                .withRequestUUID(logBean.getRequestUUID())
                .withObjectIds(Arrays.asList(requestBean.getUrl()))
                .withRequestEntity(GSON.toJson(requestBean));

        MONGO_HELPER.addMongoBean(preloadedLogBean);
        return GSON.fromJson(preloadedLogBean.getResponseEntity(), PpcFeedToBannerlandResponseBean.class);
    }
}
