package ru.yandex.autotests.direct.fakebsproxy.service;

import org.springframework.stereotype.Service;
import ru.yandex.autotests.direct.fakebsproxy.beans.FakeBSProxyLogBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.updatestorecontent.UpdateStoreContentMobileRequestBean;
import ru.yandex.autotests.direct.fakebsproxy.beans.updatestorecontent.UpdateStoreContentMobileResponseBean;
import ru.yandex.autotests.direct.fakebsproxy.dao.FakeBSProxyLogBeanMongoHelper;

/**
 * Created by buhter on 29/07/15.
 */
@Service
public class FakeProxyUpdateStoreContentService {

    private static final FakeBSProxyLogBeanMongoHelper MONGO_HELPER = new FakeBSProxyLogBeanMongoHelper();

    public UpdateStoreContentMobileResponseBean handleUpdateStoreContentRequest(FakeBSProxyLogBean logBean
            , UpdateStoreContentMobileRequestBean requestBean) {

        FakeBSProxyLogBean preloadedLogBean = MONGO_HELPER.getFakeBSProxyLogBeanById(requestBean.getAppId()
                + ":" + requestBean.getCountry());

        logBean = new FakeBSProxyLogBean(preloadedLogBean
                .withHeaders(logBean.getHeaders())
                .withRequestEntity(requestBean.toString())
                .withRequestUUID(requestBean.toString() + System.currentTimeMillis()));

        if (logBean.getResponseEntity() == null) {
            logBean.setResponseEntity("Couldn't resolve response");
        }

        MONGO_HELPER.addMongoBean(logBean);
        return new UpdateStoreContentMobileResponseBean().fromString(logBean.getResponseEntity());
    }
}
