package ru.yandex.autotests.direct.fakebsproxy.service.utils;

import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.net.URI;
import java.util.Map;

/**
 * Created by buhter on 24/08/15.
 */
public class FakeBsProxyHttpClient {

    private final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    public String post(URI uri, String requestEntity, String mediaType) throws IOException {
        try {
            HttpPost post = new HttpPost();
            post.setURI(uri);
            post.setConfig(RequestConfig.custom().setConnectTimeout(DEFAULT_SOCKET_TIMEOUT)
                    .setSocketTimeout(DEFAULT_SOCKET_TIMEOUT).build());
            StringEntity entity = new StringEntity(requestEntity, Consts.UTF_8);
            entity.setContentType(mediaType);
            post.setEntity(entity);
            HttpEntity responseEntity = httpClient.execute(post).getEntity();
            return EntityUtils.toString(responseEntity);
        } catch (IOException e) {
            return e.getMessage();
        } finally {
            httpClient.close();
        }
    }

    public String post(URI uri, String requestEntity, Map<String, String> headers, String mediaType) throws IOException {
        try {
            HttpPost post = new HttpPost();
            headers.entrySet().forEach(o -> post.setHeader(o.getKey(), o.getValue()));
            post.removeHeaders("Content-Length");
            post.setURI(uri);
            post.setConfig(RequestConfig.custom().setConnectTimeout(DEFAULT_SOCKET_TIMEOUT)
                    .setSocketTimeout(DEFAULT_SOCKET_TIMEOUT).build());
            StringEntity entity = new StringEntity(requestEntity, Consts.UTF_8);
            entity.setContentType(mediaType);
            post.setEntity(entity);
            HttpEntity responseEntity = httpClient.execute(post).getEntity();
            return EntityUtils.toString(responseEntity);
        } catch (IOException e) {
            return e.getMessage();
        } finally {
            httpClient.close();
        }
    }

    public String get(URI uri) throws IOException {
        try {
            HttpEntity responseEntity = httpClient.execute(new HttpGet(uri)).getEntity();
            return EntityUtils.toString(responseEntity);
        } catch (IOException e) {
            return e.getMessage();
        } finally {
            httpClient.close();
        }
    }
}
