package ru.yandex.autotests.httpclient.lite.core;

import org.apache.http.entity.ContentType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import ru.yandex.autotests.httpclient.lite.core.config.HttpClientProperties;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class ResponseContent {

    public static final ResponseContent NO_CONTENT = new ResponseContent(new byte[] {}, ContentType.DEFAULT_BINARY);

    private final byte[] raw;
    private final ContentType type;
    private int statusCode;

    public ResponseContent(final byte[] raw, final ContentType type) {
        super();
        this.raw = raw;
        this.type = type;
    }

    public ContentType getType() {
        return this.type;
    }

    public byte[] asBytes() {
        return this.raw.clone();
    }

    public String asString() {
        Charset charset = this.type.getCharset();
        if (charset == null) {
            charset = HttpClientProperties.get().getResponseContentCharsetDefault();
        }
        try {
            return new String(this.raw, charset.name());
        } catch (final UnsupportedEncodingException ex) {
            return new String(this.raw);
        }
    }

    public Document asDocument() {
        return Jsoup.parse(this.asString());
    }

    public InputStream asStream() {
        return new ByteArrayInputStream(this.raw);
    }

    public int getStatusCode() {
        return statusCode;
    }

    public ResponseContent withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public String toString() {
        return asString();
    }
}
