package ru.yandex.autotests.httpclient.lite.core.config;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class HttpClientConnectionConfig {
    private String scheme;
    private String host;
    private Integer port;
    private String path;
    private String proxyAddress;
    private Integer proxyPort;
    //http://hc.apache.org/httpcomponents-client-ga/httpclient/apidocs/org/apache/http/client/config/RequestConfig.html#getConnectTimeout()
    //sec
    private int timeout = -1;

    public HttpClientConnectionConfig scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpClientConnectionConfig host(String host) {
        this.host = host;
        return this;
    }

    public HttpClientConnectionConfig port(Integer port) {
        this.port = port;
        return this;
    }


    public HttpClientConnectionConfig path(String path) {
        this.path = path;
        return this;
    }

    public HttpClientConnectionConfig timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getScheme() {
        return scheme;
    }

    public String getHost() {
        return host;
    }

    public Integer getPort() {
        return port;
    }

    public String getPath() {
        return path;
    }

    public String getProxyAddress() {
        if(proxyAddress == null) {
            proxyAddress = HttpClientProperties.get().getProxyServerAddress();
        }
        return proxyAddress;
    }

    public Integer getProxyPort() {
        if(proxyPort == null) {
            proxyPort = HttpClientProperties.get().getProxyServerPort();
        }
        return proxyPort;
    }

    public  int getTimeout(){
        return timeout;
    }
}
