package ru.yandex.autotests.httpclient.lite.core.config;

import org.apache.http.protocol.HTTP;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

import java.nio.charset.Charset;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
@Resource.Classpath("httpclient.properties")
public class HttpClientProperties {
       private static HttpClientProperties currentConfig;

    public static HttpClientProperties get() {
        if (currentConfig == null) {
            currentConfig = new HttpClientProperties();
            PropertyLoader.populate(currentConfig);
        }
        return currentConfig;
    }

    @Property("httpclient.proxy.server.address")
    private String proxyServerAddress = null;

    @Property("httpclient.proxy.server.port")
    private Integer proxyServerPort = null;

    @Property("httpclient.response.content.charset.default")
    private String responseContentCharsetDefault = HTTP.DEF_CONTENT_CHARSET.name();

    public String getProxyServerAddress() {
        return proxyServerAddress;
    }

    public Integer getProxyServerPort() {
        return proxyServerPort;
    }

    public Charset getResponseContentCharsetDefault() {
        return Charset.forName(responseContentCharsetDefault);
    }
}