package ru.yandex.autotests.httpclient.lite.core.config;

import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import ru.yandex.autotests.httpclient.lite.core.BackEndRequestBuilder;
import ru.yandex.autotests.httpclient.lite.core.BackEndResponseHandler;

import static org.junit.Assert.assertNotNull;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public class HttpStepsConfig {
    protected HttpClientConnectionConfig clientConfig;
    protected HttpClient httpClient;
    protected ResponseHandler handler;
    protected BackEndRequestBuilder requestBuilder;

    public HttpClientConnectionConfig getClientConfig() {
        return clientConfig;
    }

    public void checkConfig() {
        assertNotNull("Необходимо задать конфигурацию клиента", getClientConfig());
    }

    public HttpClient getHttpClient() {
        if(httpClient == null) {
            checkConfig();
            httpClient = HttpClientFactory.getHttpClient(getClientConfig());
        }
        return httpClient;
    }

    public ResponseHandler getHandler() {
        if(handler == null) {
            handler = new BackEndResponseHandler();
        }
        return handler;
    }

    public BackEndRequestBuilder getRequestBuilder() {
        if(requestBuilder == null) {
            checkConfig();
            requestBuilder = new BackEndRequestBuilder(getClientConfig());
        }
        return requestBuilder;
    }

    public HttpStepsConfig useClientConfig(HttpClientConnectionConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    public HttpStepsConfig useHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpStepsConfig useHandler(ResponseHandler handler) {
        this.handler = handler;
        return this;
    }

    public HttpStepsConfig useRequestBuilder(BackEndRequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
        return this;
    }
}
