package ru.yandex.autotests.httpclient.lite.core.steps;

import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import ru.yandex.autotests.httpclient.lite.core.BackEndRequestBuilder;
import ru.yandex.autotests.httpclient.lite.core.BackEndResponse;
import ru.yandex.autotests.httpclient.lite.core.config.HttpStepsConfig;
import ru.yandex.autotests.httpclient.lite.core.exceptions.BackEndClientException;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;

import java.io.IOException;
import java.util.List;

import static ru.yandex.autotests.httpclient.lite.utils.HttpUtils.getMethodParams;
import static ru.yandex.autotests.httpclient.lite.utils.HttpUtils.getURI;


/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public abstract class BackEndBaseSteps {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    protected HttpStepsConfig config;

    protected static MultiKeyMap<MultiKey<Object>, BackEndBaseSteps> steps;
    
    protected static MultiKeyMap<MultiKey<Object>, BackEndBaseSteps> getSteps() {
        if (steps == null) {
            steps = new MultiKeyMap<>();
        }
        return steps;
    }

    protected void init(HttpStepsConfig config) {
        this.config = config;
    }

    protected <T extends BackEndRequestBuilder> T getRequestBuilder() {
        return (T) config.getRequestBuilder();
    }

    public static <T extends BackEndBaseSteps> T getInstance(Class<T> stepsClass, HttpStepsConfig config) {
        MultiKey key = getKey(stepsClass, config);
        if (!getSteps().containsKey(key)) {
            try {
                BackEndBaseSteps stepsInstance = stepsClass.newInstance();
                stepsInstance.init(config);
                getSteps().put(key, stepsInstance);
            } catch (InstantiationException | IllegalAccessException e) {
                throw new BackEndClientException("Cannot instantiate steps " + stepsClass.getName(), e);
            }
        }
        return (T) getSteps().get(key);
    }

    public <T extends BackEndResponse> T execute(HttpUriRequest method) {
        try {
            logRequest(method);
            return (T) config.getHttpClient().execute(method, config.getHandler());
        } catch (IOException e) {
            throw new BackEndClientException("Execution failed", e);
        }
    }

    private static <T extends BackEndBaseSteps> MultiKey<Object> getKey(Class<T> stepsClass, HttpStepsConfig config) {
        return new MultiKey<>(new Object[]{stepsClass, config});
    }

    private void logRequest(HttpUriRequest method) {
        List<NameValuePair> methodParams = getMethodParams(method);
        String address = getURI(method);
        log.info("Request: " + method.getMethod() + " " + address +"\n" +
                StringUtils.join(methodParams, "\n"));
    }
}
