import javaposse.jobdsl.dsl.helpers.scm.SvnDepth
import util.Constants

credentialsId = 'robot-irt-jenkins-ssh'
folder = 'direct-applications'
qloudUri = 'https://qloud.yandex-team.ru'

folder(folder)

job(folder + "/direct-handles-static") {

    logRotator {
        numToKeep(10)
    }

    parameters {
        stringParam('IMAGE', 'direct-qa/applications', '')
        stringParam('TAG', 'direct-handles-static-latest', '')
        choiceParam('ENV', ['test', 'prod'])
        stringParam('REPOSITORY', 'registry.yandex.net', '')
        stringParam('QLOUD_URI', qloudUri, '')
        booleanParam('REBUILD_CONTAINER', true, 'Перебилдить контейнер')
    }

    label('direct-jenkins-docker-slave || direct-jenkins-slave-docker')

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
    }

    scm {
        svn {
            location(Constants.SVN_LOCATION + "/direct-handles-frontend") {
                credentials(Constants.SVN_CREDENTIALS)
                directory(".")
                depth(SvnDepth.INFINITY)
            }
        }
    }

    triggers {
        scm("H/5 * * * *")
    }

    steps {
        conditionalSteps {
            condition {
                stringsMatch('$REBUILD_CONTAINER', 'true', true)
            }
            steps {
                dockerBuilderPublisher {
                    dockerFileDirectory('$WORKSPACE')
                    fromRegistry {
                        url('https://$REPOSITORY/v2/')
                        credentialsId(Constants.DOCKER_CREDENTIALS)
                    }
                    cloud('docker')
                    tagsString('$REPOSITORY/$IMAGE:$TAG')
                    pushOnSuccess(true)
                    pushCredentialsId(Constants.DOCKER_CREDENTIALS)
                    cleanImages(true)
                    cleanupWithJenkinsJobDelete(false)
                }
            }
        }
    }

    publishers {
        qloudDeployer {
            credentialsId('robot-irt-jenkins-qloud')
            deployConfig('{"qloudUri": "$QLOUD_URI", "envId": "direct-infra.direct-handles.$ENV", "component": "direct-handles-static", "image": "$IMAGE", "tag": "$TAG"}')
        }
    }
}
