import util.Constants

credentialsId = 'robot-irt-jenkins-ssh'
folder = 'direct-applications'
qloudUri = 'https://qloud.yandex-team.ru'

folder(folder)

job(folder + "/directsteps-proxy") {

    logRotator {
        numToKeep(10)
    }

    parameters {
        stringParam('IMAGE', 'direct-qa/applications', '')
        stringParam('TAG', 'apisteps-proxy', '')
        choiceParam('ENV', ['prod', 'test'])
        stringParam('REPOSITORY', 'registry.yandex.net', '')
        stringParam('QLOUD_URI', qloudUri, '')
        booleanParam('REBUILD_CONTAINER', true, 'Перебилдить контейнер')
    }

    description("Собирает direct-steps-proxy, делает докерный контейнер, пушит в Docker-registry, откуда потом обновляет указанное окружение Qloud")

    label('direct-jenkins-docker-slave || direct-jenkins-slave-docker')

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
    }

    scm {
        svn {
            location(Constants.SVN_LOCATION + '/direct-steps-proxy') {
                credentials(Constants.SVN_CREDENTIALS)
                directory('.')
                depth(SvnDepth.INFINITY)
            }
        }
    }


    steps {
        conditionalSteps {
            condition {
                stringsMatch('$REBUILD_CONTAINER', 'true', true)
            }
            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('-Dmaven.test.skip=true clean package')
                }
                dockerBuilderPublisher {
                    dockerFileDirectory('$WORKSPACE')
                    fromRegistry {
                        url('https://$REPOSITORY/v2/')
                        credentialsId(Constants.DOCKER_CREDENTIALS)
                    }
                    cloud('docker')
                    tagsString('$REPOSITORY/$IMAGE:$TAG')
                    pushOnSuccess(true)
                    pushCredentialsId(Constants.DOCKER_CREDENTIALS)
                    cleanImages(true)
                    cleanupWithJenkinsJobDelete(false)
                }
            }
        }
    }

    publishers {
        qloudDeployer {
            credentialsId('robot-irt-jenkins-qloud')
            deployConfig('{"qloudUri": "$QLOUD_URI", "envId": "direct-infra.apisteps-proxy.$ENV", "component": "apisteps-proxy", "image": "$IMAGE", "tag": "$TAG"}')
        }
    }
}
