import javaposse.jobdsl.dsl.helpers.scm.SvnDepth
import util.Constants

credentialsId = 'robot-irt-jenkins-ssh'
folder = 'applications'

folder(folder)

job(folder + "/jetty-starter") {

    logRotator {
        numToKeep(10)
    }

    parameters {
    }

    label('direct-jenkins-docker-slave || direct-jenkins-slave-docker')

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
    }

    scm {
        svn {
            location(Constants.SVN_LOCATION + '/jetty-starter') {
                credentials(Constants.SVN_CREDENTIALS)
                directory('.')
                depth(SvnDepth.INFINITY)
            }
        }
    }

    steps {
        maven {
            mavenInstallation('maven-3.3.9')
            goals('clean package')
        }
    }

    publishers {
        archiveArtifacts('target/jetty-starter.jar')
    }
}
