package applications
import util.Constants

credentialsId = 'robot-irt-jenkins-ssh'
folder = 'direct-applications'
qloudUri = 'https://qloud.yandex-team.ru'

folder(folder)

job(folder + "/radar-static") {

    logRotator {
        numToKeep(10)
    }

    parameters {
        stringParam('BRANCH_NAME', 'master', '')
        stringParam('IMAGE', 'direct-qa/applications', '')
        stringParam('TAG', 'radar-static-latest', '')
        choiceParam('ENV', ['test', 'prod'])
        stringParam('REPOSITORY', 'registry.yandex.net', '')
        stringParam('QLOUD_URI', qloudUri, '')
        booleanParam('REBUILD_CONTAINER', true, 'Перебилдить контейнер')
    }

    properties {
        githubProjectUrl('https://github.yandex-team.ru/qa-irt/radar')
    }

    label('direct-jenkins-docker-slave || direct-jenkins-slave-docker')

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
    }

    scm {
        git {
            remote {
                url('git@github.yandex-team.ru:qa-irt/radar.git')
                credentials(credentialsId)
                branch('$BRANCH_NAME')
            }
        }
    }

    triggers {
        scm("H/5 * * * *")
    }

    steps {
        conditionalSteps {
                condition {
                    stringsMatch('$REBUILD_CONTAINER', 'true', true)    
                }
                steps {
                    maven {
                        mavenInstallation('maven-3.3.9')
                        goals('clean package')
                    }
                    copyArtifacts('applications/jetty-starter') {
                        flatten()
                        buildSelector {
                            latestSuccessful(true)
                        }
                    }
                    dockerBuilderPublisher {
                        dockerFileDirectory('$WORKSPACE/radar-web')
                        fromRegistry {
                            url('https://$REPOSITORY/v2/')
                            credentialsId(Constants.DOCKER_CREDENTIALS)
                        }
                        cloud('docker')
                        tagsString('$REPOSITORY/$IMAGE:$TAG')
                        pushOnSuccess(true)
                        pushCredentialsId(Constants.DOCKER_CREDENTIALS)
                        cleanImages(true)
                        cleanupWithJenkinsJobDelete(false)
                    }
                }
        }
    }
    
    publishers {
        qloudDeployer {
            credentialsId('robot-irt-jenkins-qloud')
            deployConfig('{"qloudUri": "$QLOUD_URI", "envId": "direct-infra.radar.$ENV", "component": "radar-static", "image": "$IMAGE", "tag": "$TAG"}')
        }
    }
}
