package applications
import util.Constants

credentialsId = 'robot-irt-jenkins-ssh'
folder = 'direct-applications'
qloudUri = 'https://qloud.yandex-team.ru'

folder(folder)

job(folder + "/restheart-docker") {

    logRotator {
        numToKeep(10)
    }

    parameters {
        stringParam('BRANCH_NAME', 'master', '')
        stringParam('IMAGE', 'direct-qa/applications', '')
        stringParam('VERSION', '3.0.0', '')
        choiceParam('ENV', ['test', 'bean-templates-prod', 'direct-handles-prod'], 'bean-templates для коннекта к BeanTemplates, direct-handles для коннекта к DirectHandles')
        stringParam('REPOSITORY', 'registry.yandex.net', '')
        stringParam('QLOUD_URI', qloudUri, '')
        booleanParam('REBUILD_CONTAINER', true, 'Перебилдить контейнер')
    }

    properties {
        githubProjectUrl('https://github.yandex-team.ru/qa-irt/restheart-docker')
    }

    label('direct-jenkins-docker-slave || direct-jenkins-slave-docker')

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
    }

    scm {
        git {
            remote {
                url('git@github.yandex-team.ru:qa-irt/restheart-docker')
                credentials(credentialsId)
                branch('$BRANCH_NAME')
            }
        }
    }

    triggers {
        scm("H/5 * * * *")
    }

    steps {
        conditionalSteps {
            condition {
                stringsMatch('$REBUILD_CONTAINER', 'true', true)
            }
            steps {
                dockerBuilder {
                    dockerCmd {
                        createImageCommand {
                            dockerFolder('$WORKSPACE')
                            imageTag('$REPOSITORY/$IMAGE:$VERSION')
                            dockerFile('Dockerfile')
                            noCache(false)
                            rm(false)
                            buildArgs('RELEASE=$VERSION')
                        }
                    }
                }
                dockerBuilder {
                    dockerCmd {
                        pushImageCommand {
                            image('$REPOSITORY/$IMAGE')
                            tag('$VERSION')
                            registry('')
                            dockerRegistryEndpoint {
                                url('https://$REPOSITORY/v2/')
                                credentialsId(Constants.DOCKER_CREDENTIALS)
                            }
                        }
                    }
                }
            }
        }
    }

    publishers {
        qloudDeployer {
            credentialsId('robot-irt-jenkins-qloud')
            deployConfig('{"qloudUri": "$QLOUD_URI", "envId": "direct-infra.restheart-mongo.$ENV", "component": "restheart", "image": "$IMAGE", "tag": "$VERSION"}')
        }
    }
}
