import util.Constants

folder = 'direct-qa'

folder(folder)

job(folder + "/build_direct_web") {

    logRotator {
        numToKeep(50)
    }

    parameters {
        stringParam('DEPLOY_VERSION', '3.0-SNAPSHOT', 'version to deploy artifact with')
        stringParam('STEPS_BRANCH_NAME', 'master', '')
        stringParam('TESTS_BRANCH_NAME', 'master', '')
        stringParam('FINANCE_TESTS_BRANCH_NAME', 'master', '')
        stringParam('LIGHT_TESTS_BRANCH_NAME', 'master', '')
        choiceParam('MVN_GOAL', ['deploy', 'compile', 'install'], 'maven goal')
    }

    jdk('java8')

    label('direct-jenkins-slave')

    wrappers {
        timestamps()
        colorizeOutput()
        timeout {
            absolute(10)
        }
    }

    multiscm {
        svn {
            location(Constants.SVN_LOCATION + '/direct-web-steps') {
                credentials(Constants.SVN_CREDENTIALS)
                directory('direct-web-steps')
                depth(SvnDepth.INFINITY)
            }
        }
        svn {
            location(Constants.SVN_LOCATION + '/direct-web-tests') {
                credentials(Constants.SVN_CREDENTIALS)
                directory('direct-web-tests')
                depth(SvnDepth.INFINITY)
            }
        }
    }

    steps {
        shell('ls')
        conditionalSteps {
            condition {
                not {
                    stringsMatch('$STEPS_BRANCH_NAME', '', true)
                }
            }
            steps {
                maven('versions:set -DnewVersion=$DEPLOY_VERSION versions:commit', 'direct-web-steps/pom.xml')
                maven('clean $MVN_GOAL', 'direct-web-steps/pom.xml')
            }
        }

        conditionalSteps {
            condition {
                not {
                    stringsMatch('$TESTS_BRANCH_NAME', '', true)
                }
            }
            steps {
                maven('versions:set -DnewVersion=$DEPLOY_VERSION versions:commit', 'direct-web-tests/pom.xml')
                maven('clean $MVN_GOAL -Pproduction', 'direct-web-tests/pom.xml')
            }
        }
    }
}
