package canvas

def folderName = 'canvas'
def credentialsId = 'robot-irt-jenkins-ssh'

folder(folderName)

job("$folderName/canvas-update-stand") {
    parameters {
        stringParam('BRANCH_NAME', '', 'Branch name or tag')
        stringParam('CANVAS_TAG', '', 'Build tag -- like "develop" for particular branch or "jenkins-canvas-develop-18" for particular build in the branch or "0.13.1" for particular release. Defaults to same branch as BRANCH_NAME')
        choiceParam('STAGE', ['devtest', 'test'], 'Direct stage')
    }
    configure {
        project->
            project / 'properties' / 'hudson.model.ParametersDefinitionProperty' / 'parameterDefinitions' << 
              'jp.ikedam.jenkins.plugins.extensible__choice__parameter.ExtensibleChoiceParameterDefinition' {
                name 'DIRECT_INTAPI_URL'
                editable 'true'
                editableType 'NoFilter'
                choiceListProvider(class: 'jp.ikedam.jenkins.plugins.extensible_choice_parameter.TextareaChoiceListProvider') {
                  choiceList(class: 'java.util.Arrays$ArrayList') {
                    a(class: 'string-array') {
                      string('https://8999.beta1.intapi.direct.yandex.ru')
                      string('http://test-direct.yandex.ru:9000')
                    }
                  }
                }
              }
    }

    concurrentBuild()

    label('direct-jenkins-autotests-slave')

	logRotator {
        numToKeep(40)
    }

    wrappers {
        timestamps()
        colorizeOutput()
        sshAgent('robot-irt-jenkins-ssh')
        credentialsBinding {
            string('QLOUD_TOKEN', 'QLOUD_TOKEN')
        }
    }

    scm {
        git {
            remote {
                url('git@github.yandex-team.ru:Canvas/canvas.git')
                credentials(credentialsId)
                branch('$BRANCH_NAME')
            }
            extensions {
            	relativeTargetDirectory('canvas')
            }
        }
    }
    steps {
    	shell('if [ -z "$DIRECT_INTAPI_URL" ]\n' +
                'then\n' +
                '  echo "необходимо задать DIRECT_INTAPI_URL"\n' +
                '  exit 1\n' +
                'fi')
    	shell('yav get version sec-01cq6y0tkh6t0q0jdwdps3w342 -o secrets > secrets') 	   
    }

    steps {
	configure EnvInject.envInject('secrets')
        //todo canvas_mongo_dump_resource_id
        shell('ansible-galaxy install -f -r canvas/ansible/requirements.yml')
        shell('ansible-playbook -e qloud_token=$QLOUD_TOKEN -e direct_stage=${STAGE} -e direct_intapi_url=${DIRECT_INTAPI_URL} -e container_tag=${CANVAS_TAG} -e canvas_mongo_dump_resource_id=610192235 -e demo_with_prod_data=true -e AUTH_INTERNAL_API_TOKEN=$AUTH_INTERNAL_API_TOKEN -e DIRECT_AUTH_TOKEN=$DIRECT_AUTH_TOKEN -e INTERNAL_API_TOKEN=$INTERNAL_API_TOKEN -e FILE_API_INTERNAL_TOKEN=$FILE_API_INTERNAL_TOKEN -e MDS_AUTH_TOKEN="$MDS_AUTH_TOKEN" -e MONITORING_TOKEN=$MONITORING_TOKEN -e SANDBOX_HOOK_SECRET=$SANDBOX_HOOK_SECRET -e SANDBOX_OAUTH_TOKEN=$SANDBOX_OAUTH_TOKEN canvas/ansible/qloud_direct_test.yml')
    }

    publishers {
        groovyPostBuild('manager.addShortText("${manager.build.buildVariables.get(\'STAGE\')}: ${manager.build.buildVariables.get(\'CANVAS_TAG\')}")', Behavior.DoNothing)
    }
}

class EnvInject {
  static ENVINJECT_VERSION = '1.90'
  static Closure envInject(String propertiesFile) {
    return { node ->
      node / builders << "EnvInjectBuilder"(
      plugin: "envinject@$ENVINJECT_VERSION") {
        info() {
          propertiesFilePath(propertiesFile)
        }
      }
    }
  }
}
