package cron

def folderName = 'cron'

folder(folderName)

job("$folderName/collect-yesterday-stats") {

    def cronStr = '0 3 * * *'

    description("Сбор статистики из Startrek\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X GET https://radar.qart.yandex-team.ru/radar-rest/startrek/collect-yesterday-stats')
    }
}

job("$folderName/check-if-release") {
    disabled()

    def cronStr = '*/15 * * * 1-7'

    description("Обработка релизного тикета для perl-релиза\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/onduty/check-if-release')
    }
}

job("$folderName/check-if-java-api5-release") {
    disabled()

    def cronStr = '*/15 * * * 1-7' // Проверяем каждые 15 минут

    description("Обработка релизного тикета для java-ap5-релиза\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/onduty/check-if-java-release/?serviceTag=java_api5')
    }
}

job("$folderName/check-if-java-intapi-release") {
    disabled()

    def cronStr = '*/15 * * * 1-5' // Проверяем каждые 15 минут

    description("Обработка релизного тикета для java-intapi-релиза\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/onduty/check-if-java-release/?serviceTag=java_intapi')
    }
}

job("$folderName/check-if-java-web-release") {
    disabled()

    def cronStr = '*/15 * * * 1-7' // Проверяем каждые 15 минут

    description("Обработка релизного тикета для java-web-релиза\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/onduty/check-if-java-release/?serviceTag=java_web')
    }
}

job("$folderName/test-direct-mod-release") {
    
    def cronStr = '*/15 6-18 * * 1-5'

    description("Обработка релизного тикета модерации\ncron $cronStr")

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/onduty/test-direct-mod-release')
    }
}

job("$folderName/check-if-dna-release") {
    disabled()

    def cronStr = '*/15 * * * 1-7' // Проверяем каждые 15 минут

    description("Обработка релизного тикета для dna-релиза\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/onduty/check-if-dna-release')
    }
}

job("$folderName/collect-end-of-day-stats") {

    def cronStr = '0 20 * * *'

    description("Обновление статистики Startrek на конец дня\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X GET https://radar.qart.yandex-team.ru/radar-rest/startrek/collect-end-of-day-stats')
    }
}

job("$folderName/post-issue-api-qa-statistics") {

    def cronStr = '0 0 * * *'

    description("Обновление статистики Startrek на конец дня\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X POST https://radar.qart.yandex-team.ru/radar-rest/startrek/post-issue-api-qa-statistics')
    }
}

job("$folderName/update-duty-passed") {

    def cronStr = '1 0 * * *'

    description("Проверка окончания дежурств\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X GET https://radar.qart.yandex-team.ru/radar-rest/onduty/update-duty-passed')
    }
}

job("$folderName/update-duty-visible") {

    def cronStr = '15 0 * * *'

    description("Проверка таблицы дежурств на вики\ncron $cronStr")

    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    triggers {
        cron("$cronStr")
    }

    steps {
        shell('curl -kv -X GET https://radar.qart.yandex-team.ru/radar-rest/onduty/update-duty-visible')
    }
}


