folder = 'direct-java-ci'

folder(folder)

job(folder + "/arcadia_slaves_cleanup_start") {
    label('direct-jenkins-arcadia-slave || direct-jenkins-slave')
    logRotator {
        numToKeep(10)
    }

    triggers {
        cron('0 2 * * *')
    }
    disabled()

    configure {
        it / 'builders' << 'hudson.plugins.parameterizedtrigger.TriggerBuilder'(plugin: 'parameterized-trigger@2.32') {
            configs {
                'hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig' {
                    configs('class': 'empty-list')
                    configFactories {
                        'org.jvnet.jenkins.plugins.nodelabelparameter.parameterizedtrigger.AllNodesForLabelBuildParameterFactory'(plugin: 'nodelabelparameter@1.7.2') {
                            name('NODE')
                            nodeLabel('direct-jenkins-arcadia-slave')
                            ignoreOfflineNodes('true')
                        }
                    }
                    projects('direct-java-ci/arcadia_slave_cleanup')
                    condition('ALWAYS')
                    triggerWithNoParameters('false')
                    buildAllNodesWithLabel('true')
                    block {
                        buildStepFailureThreshold {
                            name('FAILURE')
                            ordinal('2')
                            completeBuild('true')
                            color('RED')
                        }
                        unstableThreshold {
                            name('UNSTABLE')
                            ordinal('1')
                            completeBuild('true')
                            color('YELLOW')
                        }
                        failureThreshold {
                            name('FAILURE')
                            ordinal('2')
                            completeBuild('true')
                            olor('RED')
                        }
                    }
                }
            }
        }
    }
}
