export PATH=/bin:/usr/bin
ulimit -m 8000000

if [ -d arcadia ]; then
    cd arcadia

    echo "Clean working copy"
    rm -rf `svn st . | grep "^?" | cut -f2-9 -d' '`
    svn revert -R .

    svn up -r ${SVN_REVISION_1}
else
    svn cat svn+ssh://a.yandex-team.ru/arc/trunk/arcadia/ya | python - clone
    cd arcadia
fi

export PATH=$PATH:$(pwd)

eatmydata -- ya make --checkout -j0 -t direct
eatmydata -- ya make --checkout -j0 devtools/jacoco-agent

cd direct

[ -d target ] && rm -r target

export REVIEW_TOOL_SRC_PATH="libs/python/review-report"
export REVIEW_TOOL_PATH="$(pwd)/target/direct/${REVIEW_TOOL_SRC_PATH}"
export PATH=$PATH:${REVIEW_TOOL_PATH}

echo "Build review tool"
eatmydata -- ya make --output target --checkout ${REVIEW_TOOL_SRC_PATH}

echo "Scanning ReviewBoard. Preparing for review."
review-report start-review --verbose ${RB_TOKEN}

if [ ! -e .rb.rr.id ]; then
    exit 0  # no review request was taken for analysis
fi

echo "Disabling jstyle checks"
echo "Index: libs/common.inc
===================================================================
@@ -1,4 +1,4 @@
-LINT(strict)
+NO_LINT()

 EXCLUDE (
     contrib/java/org/slf4j/slf4j-log4j12
" > no_lint.diff

patch -p0 < no_lint.diff

echo "Run build"
eatmydata -- ya make -tA -j1\
    --test-threads=1        \
    --test-disable-timeout  \
    --output target         \
    --java-coverage         \
    -k                      \
    --jvm-args=-Xmx4G       \
    --coverage-report       \
    || echo "Proceed."

# sonar cannot read this report for some reason
[ -e libs/interruption/ut/report.exec ] && rm libs/interruption/ut/report.exec
# remove empty jacoco reports, sonar fails reading them
find . -name "report.exec" -empty -delete

# Storing libs and classes for sonar scanner
cd target
mkdir libs classes
cp direct/**/*.jar libs/
cp direct/libs/**/*.jar libs/
rm libs/*sources.jar

# Extracting classes
cd classes
find ../libs/ -name "*.jar" -exec jar xf "{}" ";"
cd ../..

echo "Running SonarQube analysis"
java  -Xmx4G -jar sonar/sonar-scanner-cli-2.8.jar               \
    -Dsonar.host.url=https://sonar.qart.yandex-team.ru          \
    -Dsonar.login=92cfa89a50bb1bd3577a5cb2c54b610fa931e346      \
    -Dsonar.svn.username=robot-irt-jenkins                      \
    -Dsonar.svn.privateKeyPath=${SVN_SSH_PRIVATE_KEY_PATH}      \
    -Dsonar.analysis.mode=preview                               \
    -Dsonar.issuesReport.lightModeOnly=true                     \
    -Dsonar.issuesReport.html.enable=true                       \
    -Dsonar.issuesReport.console.enable=true                    \
    -Djava.net.preferIPv4Stack=false                            \
    -Djava.net.preferIPv6Addresses=true                         \
    || echo "Proceed."

review-report upload-sonar --verbose

export JACOCO_REPORT_PATH=$(readlink ../java.coverage.report)
if [ "$JACOCO_REPORT_PATH" ]; then
    sudo chmod -R 777 ${JACOCO_REPORT_PATH}
    review-report upload-coverage --verbose --no-xmllint ${JACOCO_REPORT_PATH}
fi

review-report post-review ${RB_TOKEN}
