export PATH=/bin:/usr/bin
ulimit -m 8000000

if [ -d arcadia ]; then
    cd arcadia
    svn up -r ${SVN_REVISION_1}
else
    svn cat svn+ssh://a.yandex-team.ru/arc/trunk/arcadia/ya | python - clone
    cd arcadia
fi

export PATH=$PATH:$(pwd)

eatmydata -- ya make --checkout -j0 -t direct
eatmydata -- ya make --checkout -j0 devtools/jacoco-agent

cd direct

[ -d target ] && rm -r target
find ../.. -name "TEST-ALL.xml" -delete

# Run build
eatmydata -- ya make -tA -j1\
    --test-threads=1        \
    --test-disable-timeout  \
    --junit=TEST-ALL.xml    \
    --output target         \
    --java-coverage         \
    -k                      \
    --jvm-args=-Xmx4G       \
    || echo "Proceed to Sonar scanning even if some tests have failed"

# sonar cannot read this report for some reason
[ -e libs/interruption/ut/report.exec ] && rm libs/interruption/ut/report.exec
# remove empty jacoco reports, sonar fails reading them
find . -name "report.exec" -empty -delete

# Storing libs and classes for sonar scanner
cd target
mkdir libs classes
cp direct/**/*.jar libs/
cp direct/libs/**/*.jar libs/
rm libs/*sources.jar

# Extracting classes
cd classes
find ../libs/ -name "*.jar" -exec jar xf "{}" ";"
cd ../..

java -Xmx4G -jar sonar/sonar-scanner-cli-2.8.jar                \
    -Dsonar.host.url=https://sonar.qart.yandex-team.ru          \
    -Dsonar.login=92cfa89a50bb1bd3577a5cb2c54b610fa931e346      \
    -Dsonar.scm.provider=svn                                    \
    -Dsonar.scm.disabled=false                                  \
    -Dsonar.svn.username=robot-irt-jenkins                      \
    -Dsonar.svn.privateKeyPath=${SVN_SSH_PRIVATE_KEY_PATH}      \
    -Dsonar.issuesReport.lightModeOnly=true                     \
    -Dsonar.issuesReport.html.enable=true                       \
    -Dsonar.issuesReport.console.enable=true                    \
    -Djava.net.preferIPv4Stack=false                            \
    -Djava.net.preferIPv6Addresses=true                         \
    || echo "WA to skip Sonar failure"
