scriptString = readFileFromWorkspace('direct-java-ci/build_review.sh')

folder = 'direct-java-ci'

folder(folder)

job(folder + "/reviewer") {
    label('direct-jenkins-arcadia-slave || direct-jenkins-slave')

    scm {
        svn {
            location('svn+ssh://a.yandex-team.ru/arc/trunk/arcadia/direct') {
                credentials("c1d28c89-10e2-47a6-a290-bb157f5a9403")
                directory("direct")
                depth(SvnDepth.EMPTY)
            }
        }
    }

    concurrentBuild()

    throttleConcurrentBuilds {
        maxPerNode(1)
        maxTotal(3)
    }

    triggers {
        cron('H/10 * * * *') // every 10 minutes
    }

    properties {
        sidebarLinks {
            link('https://sonar.qart.yandex-team.ru', 'SonarQube', '/userContent/sonar.svg')
        }
    }

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
        credentialsBinding {
            file('SVN_SSH_PRIVATE_KEY_PATH', '8875254c-b682-4152-91f5-69c884c8cee1')
            string('RB_TOKEN', 'robot-irt-jenkins-qloud')
        }
    }

    logRotator {
        numToKeep(30)
    }

    steps {
        shell(scriptString)
    }

    publishers {
        buildDescription(/(.*Nothing.interesting.*|.*Review.request.URL.*)/)
    }
}
