import util.Constants

scriptString = readFileFromWorkspace('direct-java-ci/build_trunk.sh')

folder = 'direct-java-ci'

folder(folder)

job(folder + "/trunk") {
    label('direct-jenkins-arcadia-slave || direct-jenkins-slave')

    scm {
        svn {
            location('svn+ssh://a.yandex-team.ru/arc/trunk/arcadia/direct') {
                credentials(Constants.SVN_CREDENTIALS)
                directory("direct")
                depth(SvnDepth.EMPTY)
            }
        }
    }

    concurrentBuild()

    throttleConcurrentBuilds {
        maxPerNode(1)
        maxTotal(2)
    }

    properties {
        sidebarLinks {
            link('https://sonar.qart.yandex-team.ru', 'SonarQube', '/userContent/sonar.svg')
        }
    } 

    wrappers {
        sshAgent('robot-irt-jenkins-ssh')
        timestamps()
        colorizeOutput()
        credentialsBinding {
            file('SVN_SSH_PRIVATE_KEY_PATH', '8875254c-b682-4152-91f5-69c884c8cee1')
            string('RB_TOKEN', 'robot-irt-jenkins-qloud')
        }
    }

    triggers {
         scm('H/2 * * * *')
    }

    logRotator {
        numToKeep(20)
    }

    steps {
        shell(scriptString)
    }

    publishers {
        archiveXUnit {
            jUnit {
                pattern('**/direct/TEST-ALL.xml')
            }
            skippedThresholds {
                unstable(100)
                unstableNew(100)
                failure(100)
                failureNew(100)
            }
        }
        extendedEmail {
            defaultSubject('Test results for trunk. Revision \$SVN_REVISION_1')
            defaultContent('\${JELLY_SCRIPT,template="email"}')
            attachmentPatterns('**/direct/.sonar/issues-report.tar.gz')
            triggers {
                always {
                    sendTo {
                        developers()
                        recipientList()
                        requester()
                    }
                }
            }
        }
    }
}
