package builders

class CmdStepsAndTests extends StepsAndTests {
    @Override
    Closure downstream(Map config) {
        Closure base = {}
        if (config.downstream) {
            config.downstream.each {
                def downstreamConf = it
                base = base >> {
                    steps {
                        downstreamParameterized {
                            trigger('direct-web-steps') {
                                parameters {
                                    predefinedProp('MVN_GOAL', downstreamConf.value.goal)
                                }
                            }
                            trigger('direct-applications/directsteps-proxy') {
                                parameters {
                                    predefinedProp('ENV', downstreamConf.value.env)
                                    predefinedProp('REBUILD_CONTAINER', downstreamConf.value.rebuildContainer)
                                    predefinedProp('REPOSITORY', downstreamConf.value.repository)
                                    predefinedProp('QLOUD_URI', downstreamConf.value.qloudUri)
                                    predefinedProp('IMAGE', downstreamConf.value.image)
                                    predefinedProp('TAG', downstreamConf.value.tag)
                                }
                            }
                        }
                    }
                }
            }
        }
        base
    }
}
