package builders

class DefaultBuilder extends JobBuilder {

    @Override
    Closure build(Map config) {
        Closure base = defaultBuild(config) >> {
            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('clean versions:set -DnewVersion=$DEPLOY_VERSION versions:commit')
                }
            }
        } >> {
            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('-Pupload-aqua $MVN_GOAL')
                }
            }
        }
        base = base >> downstream(config) >> params(config)
        base
    }
}
