package builders

import util.BuildUtils

class DirectDbModels extends JobBuilder {
    @Override
    Closure build(Map config) {
        config.skipPostBuild = true
        Closure base = defaultBuild(config) >> {
            parameters {
                choiceParam('STAGE', ['ts', 'ts2', 'devtest', 'dev7'])
                stringParam('REVISION', 'HEAD')
                choiceParam('MVN_GOAL', ['deploy', 'compile', 'install'])
            }

            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('versions:set -DnewVersion=1.0-$STAGE-SNAPSHOT versions:commit')
                }
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('clean $MVN_GOAL -P$STAGE')
                }
                downstreamParameterized {
                    trigger('direct-db-jooq-steps') {
                        parameters {
                            predefinedProp('DEPLOY_VERSION', '1.0-$STAGE-SNAPSHOT')
                            predefinedProp('MVN_GOAL', '$MVN_GOAL')
                        }
                    }
                }
            }

            publishers {
                groovyPostBuild('manager.addShortText("${manager.build.buildVariables.get(\'STAGE\')}: ${manager.build.buildVariables.get(\'MVN_GOAL\')}")', Behavior.DoNothing)
            }
        }
        return base
    }
}
