package builders

import util.BuildUtils

class StepsAndTests extends JobBuilder {

    @Override
    Closure build(Map config) {
        Closure base = defaultBuild(config) >> {
            parameters {
                booleanParam('SKIP_IMPORTED', true, '')
            }

            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('versions:set -DnewVersion=$DEPLOY_VERSION versions:commit')
                    rootPOM('steps/pom.xml')
                }
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('clean $MVN_GOAL -Pproduction')
                    rootPOM('steps/pom.xml')
                }
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('versions:set -DnewVersion=$DEPLOY_VERSION versions:commit')
                    rootPOM('tests/pom.xml')
                }
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('clean $MVN_GOAL -Pproduction,upload-aqua')
                    rootPOM('tests/pom.xml')
                }
            }
        }
        if (config.downstream) {
            base = base >> downstream(config)
        }
        base = base >> params(config)
        base
    }
}
