package builders

class SwaggerAndGraphQLApiClient extends JobBuilder {
    @Override
    Closure build(Map config) {
        Closure base = defaultBuild(config) >> {
            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('clean versions:set -DnewVersion=$DEPLOY_VERSION versions:commit')
                }
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('-Dweb.api.url=$API_URL -Dgraphql.api.url=$GRAPHQL_API_URL $MVN_GOAL')
                }
            }
        } >> params(config) >> {
            parameters {
                stringParam('API_URL', config.url, '')
                stringParam('GRAPHQL_API_URL', config.graphqlUrl, '')
            }
        }
        base
    }
}
