package builders

class SwaggerApiClient extends JobBuilder {
    @Override
    Closure build(Map config) {
        Closure base = defaultBuild(config) >> {
            steps {
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('clean versions:set -DnewVersion=$DEPLOY_VERSION versions:commit')
                }
                maven {
                    mavenInstallation('maven-3.3.9')
                    goals('-Dswagger.api.url=$API_URL $MVN_GOAL')
                }
            }
        } >> params(config) >> {
            parameters {
                stringParam('API_URL', config.url, '')
            }
        }
        base
    }
}
