package directci

def folderName = "direct-test-ci"
def maximumFails = 10

folder(folderName)

job("$folderName/run_dna_release_tests") {
    label('direct-jenkins-cron-slave || direct-jenkins-slave')
    jdk('java8')
    logRotator {
        numToKeep(50)
    }
    wrappers {
        timestamps()
        colorizeOutput()
        sshAgent('robot-irt-jenkins-ssh', 'a24fecef-8d55-4f2a-9122-564eebc48da9')
        buildName('release_dna_${ENV,var="tag"}')
    }
    parameters {
        stringParam('stage', 'TS', 'Среда для запуска')
        stringParam('tag', '', 'Тег для ланчей в акве')
    }

    steps {
        aqua {
            packs {
                // тесты интерфейса на английском языке
                pack('5b8ee3ec4a945d01ddf81878') { // directweb: smoke pack language - en
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                }
            }
        }

        // dna тесты нового интерфейса
        downstreamParameterized {
            trigger('direct-test-ci/run_dna_tests') {
                parameters {
                    predefinedProp('BRANCH', 'master')
                    predefinedProp('PORT', 'TS')
                }
            }
        }
    }
}
