package directci

def folderName = "direct-test-ci"
def maximumFails = 10
def directStageParamName = 'direct.stage'
def directSandboxUiStageParamName = 'direct.api.sandbox.ui.stage'
def directStageParamValue = '$stage'
def directSandboxStageParamValue = '$sandbox_stage'
def semaphorePermitsName = 'direct.semaphore.permits'

folder(folderName)

job("$folderName/run_java_release_tests") {
    label('direct-jenkins-cron-slave || direct-jenkins-slave')

    jdk('java8')

    logRotator {
        numToKeep(50)
    }

    concurrentBuild()

    wrappers {
        timestamps()
        colorizeOutput()
        sshAgent('robot-irt-jenkins-ssh', 'a24fecef-8d55-4f2a-9122-564eebc48da9')
        buildName('release_${ENV,var="tag"}')
    }

    parameters {
        stringParam('stage', 'TS', 'Среда для запуска')
        stringParam('$sandbox_stage', 'SANDBOX_TS', 'Песочница для запуска')
        stringParam('tag', '', 'Тег для ланчей в акве')
        stringParam('serviceTag', '', 'Тег сервиса для которого надо запустить aqua-паки (java_api5, java_intapi, java_web)')
        stringParam('hazelcastDisable', 'false', 'Включение haselcast')
        stringParam('webPermits', '20', 'ограничение семафора для тестов веба')
    }

    steps {
        // Direct API5
        conditionalSteps {
            condition {
                stringsMatch('${serviceTag}', 'java_api5', false)
            }
            runner('Fail')
            steps {
                aqua {
                    packs {
                        // Autotests Direct.API5 AgencyClients
                        // https://aqua.yandex-team.ru/#/pack/58a4792fe4b05385ac6c56d2
                        pack('58a4792fe4b05385ac6c56d2') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5 KeywordsResearch
                        // https://aqua.yandex-team.ru/#/pack/58c29d1be4b05385ac782de4
                        pack('58c29d1be4b05385ac782de4') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5 AudienceTargets
                        // https://aqua.yandex-team.ru/#/pack/57d932dee4b08948c4892da5
                        pack('57d932dee4b08948c4892da5') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5 Clients
                        // https://aqua.yandex-team.ru/#/pack/56cb70eee4b09ee592479a1f
                        pack('56cb70eee4b09ee592479a1f') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5 Leads
                        // https://aqua.yandex-team.ru/#/pack/5a30ffb76412ad01a9a0f67f
                        pack('5a30ffb76412ad01a9a0f67f') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5 RetargetingLists
                        // https://aqua.yandex-team.ru/#/pack/57b477f4e4b09ee592a5f9ba
                        pack('57b477f4e4b09ee592a5f9ba') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Bids
                        // https://aqua.yandex-team.ru/#/pack/53ee1612e4b042f0f5b5773a
                        pack('53ee1612e4b042f0f5b5773a') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                            //prop(semaphorePermitsName, "30")
                        }

                        // Autotests Direct.API5. Sitelinks
                        // https://aqua.yandex-team.ru/#/pack/54e1e655e4b08ec3d977c27a
                        pack('54e1e655e4b08ec3d977c27a') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. VCards
                        // https://aqua.yandex-team.ru/#/pack/53ce3b67e4b00a721a9b5b05
                        pack('53ce3b67e4b00a721a9b5b05') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. AdExtensions
                        // https://aqua.yandex-team.ru/#/pack/56f44220e4b09ee5925783c9
                        pack('56f44220e4b09ee5925783c9') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. BidModifiers
                        // https://aqua.yandex-team.ru/#/pack/55a3a6b9e4b0cddf3e938a79
                        pack('55a3a6b9e4b0cddf3e938a79') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. AdGroups
                        // https://aqua.yandex-team.ru/#/pack/53ad3d68e4b0be888c31c39e
                        pack('53ad3d68e4b0be888c31c39e') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Ads
                        // https://aqua.yandex-team.ru/#/pack/5565db10e4b069c629b24ec2
                        pack('5565db10e4b069c629b24ec2') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Keywords
                        // https://aqua.yandex-team.ru/#/pack/546c93ece4b02219d5da4b80
                        pack('546c93ece4b02219d5da4b80') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5 DynamicTextAdTargets
                        // https://aqua.yandex-team.ru/#/pack/566ebe97e4b02aa4506389f4
                        pack('566ebe97e4b02aa4506389f4') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Changes
                        // https://aqua.yandex-team.ru/#/pack/5565fc6be4b069c629b25e0c
                        pack('5565fc6be4b069c629b25e0c') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Dictionaries
                        // https://aqua.yandex-team.ru/#/pack/56c830a6e4b08948c48275d5
                        pack('56c830a6e4b08948c48275d5') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Creatives
                        // https://aqua.yandex-team.ru/#/pack/5bad07cc8a906aec8f6584ce
                        pack('5bad07cc8a906aec8f6584ce') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API. Sandbox
                        // https://aqua.yandex-team.ru/#/pack/54228c24e4b0d5d01094a050
                        pack('54228c24e4b0d5d01094a050') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directSandboxStageParamValue)
                            prop(directSandboxUiStageParamName, directStageParamValue)
                        }

                        // Autotests Direct.API5. Campaigns
                        // https://aqua.yandex-team.ru/#/pack/55ed2fcee4b05733565024ce
                        pack('55ed2fcee4b05733565024ce') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }
                    }
                    parallel()
                }
            }
        }

        // Direct IntAPI
        conditionalSteps {
            condition {
                stringsMatch('${serviceTag}', 'java_intapi', false)
            }
            runner('Fail')
            steps {
                aqua {
                    packs {
                        // Direct java intapi
                        // https://aqua.yandex-team.ru/#/pack/58526ca6e4b04506a0ac2172
                        pack('58526ca6e4b04506a0ac2172') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }
                    }
                    parallel()
                }
            }
        }

        // Direct Web
        conditionalSteps {
            condition {
                stringsMatch('${serviceTag}', 'java_web', false)
            }
            runner('Fail')
            steps {
                aqua {
                    packs {
                        // Direct Java Web
                        // https://aqua.yandex-team.ru/#/pack/591c2e91e4b0457937ed0ce1
                        pack('591c2e91e4b0457937ed0ce1') {
                            tag('$tag')
                            threshold(maximumFails)
                            prop(directStageParamName, directStageParamValue)
                        }
                    }
                    parallel()
                }
//                downstreamParameterized {
//                    trigger('direct-test-ci/run_dna_tests') {
//                        parameters {
//                            predefinedProp('BRANCH', 'master')
//                            predefinedProp('PORT', 'TS')
//                        }
//                    }
//                }
            }
        }

        systemGroovyCommand('''\
                | import hudson.model.*
                |
                | def builder = new StringBuilder()
                |
                | def aquaLaunchesCount = Integer.parseInt(build.envVars.getOrDefault(\'AQUA_LAUNCHES_COUNT\', '0'))
                | if (aquaLaunchesCount > 0) {
                |   builder.append(\'\'\'
                |       <table border=1 style= "border-spacing:0;" cellpadding=5>
                |       <tr>
                |           <th>Feature</th>
                |           <th>Success</th>
                |           <th>Fail</th>
                |           <th>Total</th>
                |       </tr>\'\'\'.stripMargin())
                |
                |   for (i = 0; i < aquaLaunchesCount; i++) {
                |     def packName = build.envVars['NAME_AQUA_' + i]
                |     def successCount = build.envVars['SUCCESS_AQUA_' + i]
                |     def failCount = build.envVars['FAIL_AQUA_' + i]
                |     def totalCount = build.envVars['TOTAL_AQUA_' + i]
                |     def launchUrl = Arrays.asList(build.envVars['PROPERTIES_AQUA_' + i].split(','))
                |       .findResult{ it.contains('aqua.launch.url') ? it.substring(it.indexOf('=') + 1).trim() : null }
                |     builder.append("""\\
                |       <tr>
                |         <td><a href="${launchUrl}"><b>${packName}</b></a></td>
                |         <td>${successCount}</td>
                |         <td>${failCount} </td>
                |         <td>${totalCount}</td>
                |       </tr>""".stripMargin())
                |   }
                |   builder.append("</table>")
                | }
                |
                | build.addAction(
                |   new ParametersAction([new StringParameterValue("AQUA_LAUNCHES_RESULT_AS_HTML", builder.toString())]))'''.stripMargin())
    }

    publishers {
        extendedEmail {
            recipientList('direct-release@yandex-team.ru')
            replyToList('direct-autotest-dev@yandex-team.ru')
            contentType('text/html')
            triggers {
                always {
                    attachBuildLog(false)
                    sendTo {
                        recipientList()
                    }
                }
            }
            defaultSubject('Direct Release Autotests Result $tag')
            defaultContent('''\
                | <b>Результаты регрессионного тестирования $tag</b>
                | <p><a href="https://aqua.yandex-team.ru/#/launches-tag?tag=$tag" target="_blank">Все запуски в AQUA</a></p>
                | <p><a href="https://radar.qart.yandex-team.ru/release/onDuty.html">Дежурные</a></p>
                | <p>${AQUA_LAUNCHES_RESULT_AS_HTML}</p>
                | <p>Сборка: ${BUILD_URL}</p>'''.stripMargin())
        }
    }
}
