import javaposse.jobdsl.dsl.DslFactory
import util.BuildUtils

def folderName = "direct-build-projects"

folder(folderName)

BuildUtils.initConfig(this as DslFactory)
String reposListFile = "${REPOS_LIST_FILE}";
println("Using repos list file ${reposListFile}")
List<String> repos = BuildUtils.parseReposList(reposListFile)
println("Found repos: ${Arrays.toString(repos.toArray())}")

repos = repos.findAll { !BuildUtils.getConfig(it).skip }

repos.each {
    def jobName = "$folderName/$it"
    def config = BuildUtils.getConfig(it);
    def jobClosure = BuildUtils.buildJob(config)

    job(jobName, jobClosure)
}
