package directci

def folderName = "direct-test-ci"
def maximumFails = 10

folder(folderName)

job("$folderName/run_release_tests") {
    label('direct-jenkins-cron-slave || direct-jenkins-slave')
    jdk('java8')
    logRotator {
        numToKeep(50)
    }
    wrappers {
        timestamps()
        colorizeOutput()
        sshAgent('robot-irt-jenkins-ssh', 'a24fecef-8d55-4f2a-9122-564eebc48da9')
        buildName('release_${ENV,var="tag"}')
    }
    parameters {
        stringParam('stage', 'TS', 'Среда для запуска')
        stringParam('tag', '', 'Тег для ланчей в акве')
        stringParam('hazelcastDisable', 'false', 'Включение haselcast')
        stringParam('directwebBayanUrl', 'https://test-ba.yandex.ru', 'Адрес интерфейса баяна')
        stringParam('sandboxStage', 'SANDBOX_TS', 'Stage api песочницы')
        stringParam('webPermits', '80', 'ограничение семафора для тестов веба')
        stringParam('cmdPermits', '40', 'ограничение семафора для тестов cmd')
        stringParam('webNewB2BPermits', '20', 'ограничение семафора для тестов new b2b')
        stringParam('apiPermits', '80', 'ограничение семафора для тестов API')
        stringParam('transportPermits', '80', 'ограничение семафора для тестов транспорта')
    }
    steps {
        aqua {
            packs {
                pack('52a6b93ce4b07758044b4149') { // Autotests Direct.API Finance
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('52a87a2be4b07758045001f4') { // Autotests Direct.API. Statistics
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('5565fc6be4b069c629b25e0c') { // Autotests Direct.API5. Changes
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('55ed2fcee4b05733565024ce') { // Autotests Direct.API5. Campaigns
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('56d4208be4b08948c4829dfe') { // Autotests Direct.API5. AdImages
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }

                pack('5423ecb5e4b0d5d01094a2f7') { // Direct Backend
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('ba.stage', '$stage')
                    prop('direct.semaphore.permits', '$cmdPermits')
                    prop('hazelcast.disable', '$hazelcastDisable')
                }
                pack('54228c24e4b0d5d01094a050') { // Autotests Direct.API. Sandbox
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$sandboxStage')
                    prop('direct.api.sandbox.ui.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('582ac528e4b0717fa1c5937f') { // Autotests Direct B2B BS Transport New
                    tag('$tag')
                    threshold(maximumFails)
                    prop('b2b.stagetype.etalon', '9090')
                    prop('b2b.stagetype.test', '9091')
                    prop('b2b.campaigns.qty', '20')
                    prop('b2b.etalon.method', 'UPDATE_DATA_2')
                    prop('b2b.test.method', 'UPDATE_DATA_2')
                    prop('b2b.run.failed.only', 'false')
                    prop('direct.transport.check.use.scriptrunner', 'false')
                    prop('direct.semaphore.permits', '$transportPermits')
                }

                pack('57fcdbe5e4b0717fa1c2390f') { // Autotests Direct.API5 Reports
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }

                pack('522487b2e4b06176345512d8') { // Autotests Direct INTAPI
                    tag('$tag')
                    threshold(maximumFails)
                    tip(50)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('5509b4f7e4b07e43030816b9') { // Autotests Direct BS Transport
                    tag('$tag')
                    threshold(maximumFails)
                    tip(100)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$transportPermits')
                }

                pack('5822e550e4b0fdea1abc8361') { // Autotests Direct BS Transport Full Export
                    tag('$tag')
                    threshold(maximumFails)
                    tip(150)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$transportPermits')
                }
                pack('589cc079e4b05385ac693176') { // Autotests Direct.API5 Reports: back-to-back tests
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('5204f071e4b06990cc369e34') { // Autotests Direct. API Images
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('52a160b7e4b07352a742e74d') { // Autotests Direct.API. Clients
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('520e05e4e4b007a8383fcfab') { // Autotests Direct. API Retargeting
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('52a08d75e4b07352a7405ebb') { // Autotests Direct.API. Banners
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
                pack('527b77d5e4b0706bf42324ab') { // Autotests Direct.API. Campaigns
                    tag('$tag')
                    threshold(maximumFails)
                    prop('direct.stage', '$stage')
                    prop('direct.semaphore.permits', '$apiPermits')
                }
            }
            parallel()
        }
    }

    publishers {
        extendedEmail {
            recipientList('direct-release@yandex-team.ru')
            replyToList('direct-autotest-dev@yandex-team.ru')
            contentType('text/html')
            triggers {
                always {
                    attachBuildLog(false)
                    sendTo {
                        recipientList()
                    }
                }
            }
            defaultSubject('Direct Release Autotests Result $tag')
            defaultContent('''\
                | <b>Результаты регрессионного тестирования $tag</b>
                | <p><a href="https://aqua.yandex-team.ru/#/launches-tag?tag=$tag" target="_blank">Все запуски в AQUA</a></p>
                | <p><a href="https://radar.qart.yandex-team.ru/release/onDuty.html">Дежурные</a></p>
                | <table border=1 style="border-spacing:0;" cellpadding=5>
                |  <tr><th>Feature</th><th>Success</th><th>Fail</th><th>Total</th></tr>
                |  <tr> <td><a href=" $URL_AQUA_0"><b>$NAME_AQUA_0</b></a></td> <td>$SUCCESS_AQUA_0</td> <td> $FAIL_AQUA_0</td> <td>$TOTAL_AQUA_0</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_1"><b>$NAME_AQUA_1</b></a></td> <td>$SUCCESS_AQUA_1</td> <td> $FAIL_AQUA_1</td> <td>$TOTAL_AQUA_1</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_2"><b>$NAME_AQUA_2</b></a></td> <td>$SUCCESS_AQUA_2</td> <td> $FAIL_AQUA_2</td> <td>$TOTAL_AQUA_2</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_3"><b>$NAME_AQUA_3</b></a></td> <td>$SUCCESS_AQUA_3</td> <td> $FAIL_AQUA_3</td> <td>$TOTAL_AQUA_3</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_4"><b>$NAME_AQUA_4</b></a></td> <td>$SUCCESS_AQUA_4</td> <td> $FAIL_AQUA_4</td> <td>$TOTAL_AQUA_4</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_5"><b>$NAME_AQUA_5</b></a></td> <td>$SUCCESS_AQUA_5</td> <td> $FAIL_AQUA_5</td> <td>$TOTAL_AQUA_5</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_6"><b>$NAME_AQUA_6</b></a></td> <td>$SUCCESS_AQUA_6</td> <td> $FAIL_AQUA_6</td> <td>$TOTAL_AQUA_6</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_7"><b>$NAME_AQUA_7</b></a></td> <td>$SUCCESS_AQUA_7</td> <td> $FAIL_AQUA_7</td> <td>$TOTAL_AQUA_7</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_8"><b>$NAME_AQUA_8</b></a></td> <td>$SUCCESS_AQUA_8</td> <td> $FAIL_AQUA_8</td> <td>$TOTAL_AQUA_8</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_9"><b>$NAME_AQUA_9</b></a></td> <td>$SUCCESS_AQUA_9</td> <td> $FAIL_AQUA_9</td> <td>$TOTAL_AQUA_9</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_10"><b>$NAME_AQUA_10</b></a></td> <td>$SUCCESS_AQUA_10</td> <td> $FAIL_AQUA_10</td> <td>$TOTAL_AQUA_10</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_11"><b>$NAME_AQUA_11</b></a></td> <td>$SUCCESS_AQUA_11</td> <td> $FAIL_AQUA_11</td> <td>$TOTAL_AQUA_11</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_12"><b>$NAME_AQUA_12</b></a></td> <td>$SUCCESS_AQUA_12</td> <td> $FAIL_AQUA_12</td> <td>$TOTAL_AQUA_12</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_13"><b>$NAME_AQUA_13</b></a></td> <td>$SUCCESS_AQUA_13</td> <td> $FAIL_AQUA_13</td> <td>$TOTAL_AQUA_13</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_14"><b>$NAME_AQUA_14</b></a></td> <td>$SUCCESS_AQUA_14</td> <td> $FAIL_AQUA_14</td> <td>$TOTAL_AQUA_14</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_15"><b>$NAME_AQUA_15</b></a></td> <td>$SUCCESS_AQUA_15</td> <td> $FAIL_AQUA_15</td> <td>$TOTAL_AQUA_15</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_16"><b>$NAME_AQUA_16</b></a></td> <td>$SUCCESS_AQUA_16</td> <td> $FAIL_AQUA_16</td> <td>$TOTAL_AQUA_16</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_17"><b>$NAME_AQUA_17</b></a></td> <td>$SUCCESS_AQUA_17</td> <td> $FAIL_AQUA_17</td> <td>$TOTAL_AQUA_17</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_18"><b>$NAME_AQUA_18</b></a></td> <td>$SUCCESS_AQUA_18</td> <td> $FAIL_AQUA_18</td> <td>$TOTAL_AQUA_18</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_19"><b>$NAME_AQUA_19</b></a></td> <td>$SUCCESS_AQUA_19</td> <td> $FAIL_AQUA_19</td> <td>$TOTAL_AQUA_19</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_20"><b>$NAME_AQUA_20</b></a></td> <td>$SUCCESS_AQUA_20</td> <td> $FAIL_AQUA_20</td> <td>$TOTAL_AQUA_20</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_21"><b>$NAME_AQUA_21</b></a></td> <td>$SUCCESS_AQUA_21</td> <td> $FAIL_AQUA_21</td> <td>$TOTAL_AQUA_21</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_22"><b>$NAME_AQUA_22</b></a></td> <td>$SUCCESS_AQUA_22</td> <td> $FAIL_AQUA_22</td> <td>$TOTAL_AQUA_22</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_23"><b>$NAME_AQUA_23</b></a></td> <td>$SUCCESS_AQUA_23</td> <td> $FAIL_AQUA_23</td> <td>$TOTAL_AQUA_23</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_24"><b>$NAME_AQUA_24</b></a></td> <td>$SUCCESS_AQUA_24</td> <td> $FAIL_AQUA_24</td> <td>$TOTAL_AQUA_24</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_25"><b>$NAME_AQUA_25</b></a></td> <td>$SUCCESS_AQUA_25</td> <td> $FAIL_AQUA_25</td> <td>$TOTAL_AQUA_25</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_26"><b>$NAME_AQUA_26</b></a></td> <td>$SUCCESS_AQUA_26</td> <td> $FAIL_AQUA_26</td> <td>$TOTAL_AQUA_26</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_27"><b>$NAME_AQUA_27</b></a></td> <td>$SUCCESS_AQUA_27</td> <td> $FAIL_AQUA_27</td> <td>$TOTAL_AQUA_27</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_28"><b>$NAME_AQUA_28</b></a></td> <td>$SUCCESS_AQUA_28</td> <td> $FAIL_AQUA_28</td> <td>$TOTAL_AQUA_28</td> </tr>
                |  <tr> <td><a href=" $URL_AQUA_29"><b>$NAME_AQUA_29</b></a></td> <td>$SUCCESS_AQUA_29</td> <td> $FAIL_AQUA_29</td> <td>$TOTAL_AQUA_29</td> </tr>
                | </table>
                | <p>Сборка: ${BUILD_URL}</p>'''.stripMargin())
        }
    }
}
