package template;

class SemaphoreJobTemplate {
    Closure createSemaphoreJob(dispName, descr, aquaPack, startrackDashboard, conf) {
        return {
            displayName(dispName)
            description(descr)

            logRotator {
                daysToKeep(14)
                numToKeep(50)
            }

            properties {
                sidebarLinks {
                    link("http://aqua.yandex-team.ru/#/pack/$aquaPack", 'Конфигурация автотестов в AQUA', '/userContent/settings-m.png')
                    link("https://st.yandex-team.ru/dashboard/$startrackDashboard", 'Баги найденные на транке', '/userContent/icon_bug.svg')
                }
            }

            parameters {
                stringParam('revision', '', 'Ревизия')
            }

            label('direct-jenkins-cron-slave')

            wrappers {
                timeout {
                    absolute(60)
                    failBuild()
                }
                timestamps()
                sshAgent('robot-irt-jenkins-ssh', 'a24fecef-8d55-4f2a-9122-564eebc48da9')
                buildName('revision-${ENV,var="revision"}')
            }

            steps {
                downstreamParameterized {
                    trigger("create_direct_beta_revision") {
                        block {
                            buildStepFailure("FAILURE")
                            failure("FAILURE")
                            unstable("UNSTABLE")
                        }
                        parameters {
                            currentBuildParameters()
                            predefinedProp("conf", conf)
                        }
                    }
                }

                copyArtifacts('create_direct_beta_revision') {
                    buildSelector {
                        buildNumber('$TRIGGERED_BUILD_NUMBER_direct_test_ci_create_direct_beta_revision')
                    }
                    flatten(true)
                    fingerprintArtifacts(true)
                    includePatterns('**/beta_config.properties')
                }

                environmentVariables {
                    propertiesFile('beta_config.properties')
                }

                aqua {
                    packs {
                        // Autotests Direct API (trunk)
                        pack(aquaPack) {
                            tag('direct_trunk_$revision')
                            threshold(5)
                            prop('direct.stage', '$BETA_PORT')
                            prop('direct.semaphore.permits', '10')
                            prop('hazelcast.disable', 'false')
                        }
                    }
                }
            }

            publishers {
                downstreamParameterized {
                    trigger("drop_direct_beta") {
                        condition('ALWAYS')
                        parameters {
                            propertiesFile('beta_config.properties')
                        }
                    }
                }
            }
        }
    }
}
