#!/bin/bash -ex

# user + ssh
useradd -m robot-irt-jenkins && \
usermod -s /bin/bash robot-irt-jenkins && \
echo "robot-irt-jenkins ALL=(ALL) NOPASSWD: ALL" >> /etc/sudoers && \
mkdir /home/robot-irt-jenkins/.ssh || true && \
echo "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCpiT+nASMIubXXBFCtTvr2dyhd0aLm1Oy+2sco56nnqiR+bXh0pCYinsZmIm9wIvZNTZC3UKmsxtI4q1Bh96CqszMnCWtmsikk5Mw5i/b15V8NZjI0VkoBfPX70x6hPsxWpa6WEqLgtOyvWAcwaALPd7tCBjYFaiWHEkfHRx9FcF22FYMkhf6VCkL1w5LNZJ64rZzLrHYpzcN3Ms1wbEs3TPscJk8aL6ml+F0vNnq/rgxIS1pfTi4rkarzUfFv8sJzMRp7UrgdddbbN15axpHCm5opjlougRhDvMTeIQ3GgON1aGpr71mG6E+h2krvRdhTn0yFdjdSOrSXRaZw8ipf robot-irt-jenkins" > /home/robot-irt-jenkins/.ssh/authorized_keys

# maven
mkdir /home/robot-irt-jenkins/.m2 || true && \
wget -O /home/robot-irt-jenkins/.m2/settings.xml https://github.yandex-team.ru/raw/qatools/settings.xml/master/settings.xml


# install ansible
apt-get update || true && \
apt-get install -y software-properties-common && \
apt-add-repository -y ppa:ansible/ansible

# pip
curl https://bootstrap.pypa.io/get-pip.py -o /home/robot-irt-jenkins/get-pip.py
python /home/robot-irt-jenkins/get-pip.py
pip install requests deepdiff

# for slave
apt-get update || true && \
apt-get install -y yandex-jdk8 sendmail git maven subversion eatmydata openssh-client ansible=2.7.6-1ppa~trusty yandex-passport-vault-client
curl -sL https://deb.nodesource.com/setup_10.x | bash -
apt-get install -y nodejs

# known hosts
ssh-keyscan -H arcadia.yandex.ru >> /home/robot-irt-jenkins/.ssh/known_hosts && \
ssh-keyscan -H a.yandex-team.ru >> /home/robot-irt-jenkins/.ssh/known_hosts && \
ssh-keyscan -H svn.yandex.ru >> /home/robot-irt-jenkins/.ssh/known_hosts && \
for PPCDEV_NUM in 1 2 3 4 5 6 7; do
  ssh-keyscan -H ppcdev$PPCDEV_NUM.yandex.ru >> /home/robot-irt-jenkins/.ssh/known_hosts && \
  ssh-keyscan -H ppcdev$PPCDEV_NUM >> /home/robot-irt-jenkins/.ssh/known_hosts || true
done

# robot-irt-jenkins
mkdir /jenkins && \
chown robot-irt-jenkins /jenkins && \
chown robot-irt-jenkins: -R /home/robot-irt-jenkins
