package ru.yandex.autotests.direct.jetty;

import org.eclipse.jetty.server.*;
import org.eclipse.jetty.webapp.WebAppContext;

public class Starter {

    public static void main(String... args) throws Exception {
        Server server = new Server();
        server.setConnectors(new Connector[]{buildConnector(server)});
        server.setHandler(buildHandlers());
        server.start();
    }


    private static Connector buildConnector(Server server) {
        int port = Integer.parseInt(System.getProperty("port"));
        ServerConnector http = new ServerConnector(server, new HttpConnectionFactory(new HttpConfiguration()));
        http.setPort(port);
        return http;
    }


    private static Handler buildHandlers() {
        return buildWebAppContextHandler();
    }

    private static WebAppContext buildWebAppContextHandler() {
        String webappPath = System.getProperty("war");
        String contextPath = System.getProperty("contextPath");
        return new WebAppContext(webappPath, contextPath);
    }

}
