def aquaId = '57165c1fe4b08948c483c0a8'
def buildNumber = 10
def user_id = '8e46e1db-f0de-476d-ba9d-3e1e6f28bd2e'
def user = 'updater'
def folderName = 'mediaplans'

folder(folderName)

freeStyleJob(folderName + '/mediaplan_start") {
    description('Запустить медиапланы')
    parameters {
        stringParam('BRANCH_NAME', 'master', 'Ветка')
    }

    wrappers {
        sshAgent(user_id)
    }

    logRotator(-1, buildNumber, 1, -1)
    steps {
        shell(readFileFromWorkspace('ci/remote_run_and_play.sh $BRANCH_NAME'))
        environmentVariables {
            propertiesFile('$BUILD_NUMBER/direct.properties')
        }
    }
    publishers {
        downstreamParameterized {
            trigger('mediaplans_test_start') {
                condition('SUCCESS')
                parameters {
                    currentBuild()
                    propertiesFile('$BUILD_NUMBER/direct.properties')
                }
            }
        }
    }
}

freeStyleJob(folderName + '/mediaplans_test_start') {
    parameters {
        stringParam('URL', '', 'ссылка на ')
        stringParam('DIR_PATH', '', 'path')
    }
    description('Запустить тесты медиапланов')
    logRotator(-1, buildNumber, 1, -1)
    steps {
        aqua {
            packs {
                pack(aquaId) {
                    tag('auto')
                    prop('mediaplan.baseUrl', '$URL')
                }
            }
        }
    }
    publishers {
        downstreamParameterized {
            trigger('mediaplans_stop') {
                condition('ALWAYS')
                parameters {
                    currentBuild()
                    predefinedProp('DIR_PATH', '$DIR_PATH')
                }
            }
        }
    }
}

freeStyleJob(folderName + '/mediaplans_stop') {
    description('Запустить тесты медиапланов')
    logRotator(-1, buildNumber, 1, -1)
    parameters {
        stringParam('DIR_PATH', '', 'path')
    }
    wrappers {
        sshAgent(user_id)
    }
    steps {
        shell("ssh -o StrictHostKeyChecking=no " + user + '@ppcdev5 mediaplan-ctl $DIR_PATH stop')
        shell("ssh -o StrictHostKeyChecking=no " + user + '@ppcdev5 rm -rf $DIR_PATH')
    }
}
