#!/usr/bin/env bash
USER="updater"
PROPERTY_PATH="./$BUILD_NUMBER/direct.properties"
mkdir $BUILD_NUMBER
if [[ $# == 1 ]]; then
    BRANCH_NAME="$1"
fi
echo $BRANCH_NAME

RAW_PATH=$(typeset -f | ssh -o StrictHostKeyChecking=no $USER@ppcdev5 "mediaplan-create-beta -b $BRANCH_NAME" >&1 | (head -n1 && tail -n1))
DIR_PATH=""
for word in $RAW_PATH;
do
    DIR_PATH=$word
done

RAW_URL=$(typeset -f | ssh -o StrictHostKeyChecking=no $USER@ppcdev5 "mediaplan-ctl $DIR_PATH start" >&1 | (head -n1 && tail -n1))
URL=""
for word in $RAW_URL;
do
    URL=$word
done
echo -e "URL=${URL}\nPATH=${DIR_PATH}" > $PROPERTY_PATH