package ru.yandex.autotests.mediaplan;

import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

/**
 * User: ginger
 * Date: 17.02.16
 */
@Resource.Classpath("direct.properties")
public class DirectProperties {

    @Property("api.baseURL")
    protected String baseURL = null;

    @Property("mediaplan.baseUrl")
    protected String mediaplanBaseUrl;

    protected String endPoint;

    public DirectProperties() {
        PropertyLoader.populate(this);
        endPoint = mediaplanBaseUrl.split("/")[mediaplanBaseUrl.split("/").length - 1];
    }

    public String getBaseURL() {
        return baseURL;
    }

    public String getMediaplanBaseUrl() {
        return mediaplanBaseUrl;
    }

    public String getEndPoint() {
        return endPoint;
    }
}
