package ru.yandex.autotests.mediaplan.client;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import ru.yandex.autotests.httpclient.lite.core.config.HttpClientFactory;
import ru.yandex.autotests.mediaplan.exceptions.DirectException;

import javax.net.ssl.*;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;

/**
 * Changes by ginger on 17.02.16.
 */
public abstract class BaseClient implements Cloneable {

    protected ConnectionConfig connectionConfig;

    public BaseClient(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }


    static {
        disableSslVerification();
    }

    /**
     *
     * @param serviceName
     * @param methodName
     * @param params
     * @param <T>
     * @return
     */
    public abstract <T> T invokeMethod(ServiceNames serviceName, Action methodName, Object params);


    public static ContentType getHttpResponseContentType(String url) {
        try {
            CloseableHttpClient httpClient = HttpClientFactory.getHttpClient(
                    ConnectionConfig.getHttpClientConnectionConfig(url).timeout(360)
            );

            HttpGet httpRequest = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(httpRequest);
            try {
                return ContentType.parse(response.getEntity().getContentType().getValue());
            } finally {
                response.close();
            }
        } catch (Exception e) {
            throw new DirectException("Ошибка обработки доступности URL", e);
        }

    }

    public static void disableSslVerification() {
        try {
            // Create a trust manager that does not validate certificate chains
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
                @Override
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return new java.security.cert.X509Certificate[]{};
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    // Do nothing because it's test and we trust in it
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    // Do nothing because it's test and we trust in it
                }
            }
            };

            // Install the all-trusting trust manager
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new java.security.SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

            // Create all-trusting host name verifier
            HostnameVerifier allHostsValid = new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };

            // Install the all-trusting host verifier
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            throw new DirectException("Ошибка ssl алогритма", e);
        }
    }
}