package ru.yandex.autotests.mediaplan.client;

import org.apache.http.client.utils.URIBuilder;
import ru.yandex.autotests.httpclient.lite.core.config.HttpClientConnectionConfig;
import ru.yandex.autotests.httpclient.lite.core.exceptions.BackEndClientParametersException;
import ru.yandex.autotests.mediaplan.DirectProperties;
import ru.yandex.autotests.mediaplan.exceptions.DirectException;

import java.net.URI;
import java.net.URISyntaxException;

import static ru.yandex.autotests.httpclient.lite.utils.HttpUtils.buildURI;

/**
 * Changes by ginger on 17.02.16.
 */
public class ConnectionConfig implements Cloneable {
    public static final DirectProperties properties = new DirectProperties();

    //region pre-defined configurations
    public static final ConnectionConfig MEDIAPLAN = getMediaplanDefaultConfig();



    public static ConnectionConfig getMediaplanDefaultConfig() {
        ConnectionConfig config = new ConnectionConfig()
                .url(properties.getMediaplanBaseUrl());
        return config;
    }
    //endregion

    /**
     * Host like http://test-direct.yandex.ru
     */
    protected String baseURL;

    public ConnectionConfig url(String baseServiceURL) {
        this.baseURL = baseServiceURL;
        return this;
    }

    @Override
    public ConnectionConfig clone() {
        return new ConnectionConfig()
                .url(baseURL);
    }

    public ConnectionConfig() {
        this.baseURL = properties.getBaseURL();
    }

    private URI buildHostURI() {
        try {
            URIBuilder uriBuilder;
            uriBuilder = new URIBuilder()
                    .setHost(this.baseURL.replaceAll("http://", ""));
            return uriBuilder.build();
        } catch (URISyntaxException e) {
            throw new DirectException("Ошибка формирования host URI для запроса", e);
        }
    }

    public String getEndPointForV5Mediaplan(String serviceName) {
        URIBuilder uriBuilder = new URIBuilder(buildHostURI());
        uriBuilder.setScheme("http");
        uriBuilder.setPath("/" + properties.getEndPoint() + "/" + serviceName);
        try {
            return uriBuilder.build().toString();
        } catch (URISyntaxException e) {
            throw new DirectException("Ошибка формирования пути для запроса", e);
        }
    }

    public static HttpClientConnectionConfig getHttpClientConnectionConfig(String url) {
        URI uri;
        try {
            uri = buildURI(new URIBuilder(url));
        } catch (URISyntaxException e) {
            throw new BackEndClientParametersException("Failed url parsing", e);
        }

        HttpClientConnectionConfig httpClientConnectionConfig = new HttpClientConnectionConfig()
                .scheme(uri.getScheme())
                .host(uri.getHost())
                .port(uri.getPort())
                .path(uri.getPath());
        return httpClientConnectionConfig;

    }
}
