package ru.yandex.autotests.mediaplan.client;

/**
 * Changes with IntelliJ IDEA.
 * User: mariabye
 * Date: 12.06.13
 * Time: 20:38
 * Describe message to/from server and log it in common way
 */
public class HttpMessage {
    private String url;
    private String request;
    private String response;
    private String statusCode;


    public void setUrl(String url) {
        this.url = url;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public String toString(){
        StringBuilder builder = new StringBuilder();
        builder.append("URL: " + url);
        builder.append("\n");
        builder.append("REQUEST: " + request.replaceAll("(\"RawData\":)([^,]+)","$1\"<base64 data>\""));
        builder.append("\n");
        builder.append("RESPONSE: "+response);
        builder.append("\n");
        builder.append("STATUS CODE: "+statusCode);
        return builder.toString();
    }


    public String toCurlStringForJson(){
        StringBuilder builder = new StringBuilder();
        builder.append("curl -k \\");
        builder.append("\n");
        builder.append("-d '"+request.replaceAll("(\"RawData\":)([^,]+)","$1\"<base64 data>\""));
        builder.append("' \""+url+"\"\n");
        return builder.toString();
    }

    public String getResponse() {
        return response;
    }
}
