package ru.yandex.autotests.mediaplan.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

import java.util.Map;

/**
 * Changes by chicos on 24.11.14.
 */
public class JSONRequest {

    @SerializedName("params")
    private Object parameters;

    @SerializedName("method")
    private String method;

    private transient Map<String, Object> header;

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public Object getParameters() {
        return parameters;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return method;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public Map<String, Object> getHeader() {
        return header;
    }

    @Override
    public String toString() {
        JsonObject jsonRequest = new JsonObject();
        jsonRequest.addProperty("method", method);
        if (parameters != null) {
            JsonElement params = JSONBuilder.gson.toJsonTree(parameters);
            jsonRequest.add("params", params);
        }
        String request = JSONBuilder.gson.toJson(jsonRequest);
        request = request.replaceAll("\"null\"", "null");
        return request;
    }
}
