package ru.yandex.autotests.mediaplan.client;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import ru.yandex.autotests.mediaplan.exceptions.DirectException;

import java.io.IOException;

/**
 * Changes by mariabye on 14.10.14.
 */
public class ResponseStringHandler implements org.apache.http.client.ResponseHandler<String> {
    private HttpMessage httpMessage;

    public ResponseStringHandler(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
    }

    @Override
    public String handleResponse(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() == 502) {
            throw new DirectException(statusLine.toString());
        }
        if (entity == null) {
            throw new DirectException("Response contains no content");
        }
        httpMessage.setStatusCode(String.valueOf(statusLine.getStatusCode()));
        String responseData = IOUtils.toString(entity.getContent());
        httpMessage.setResponse(responseData);
        if (responseData.toLowerCase().contains("internal server error")) {
            throw new DirectException("Сервер ответил ошибкой internal server error");
        }
        return responseData;
    }
}
