package ru.yandex.autotests.mediaplan.client;

import ru.yandex.autotests.mediaplan.services.adgroups.AdGroupsService;
import ru.yandex.autotests.mediaplan.services.ads.AdsService;
import ru.yandex.autotests.mediaplan.services.bids.BidsService;
import ru.yandex.autotests.mediaplan.services.changes.ChangesService;
import ru.yandex.autotests.mediaplan.services.keywords.KeywordsService;
import ru.yandex.autotests.mediaplan.services.mediaplans.MediaplansService;
import ru.yandex.autotests.mediaplan.services.requests.RequestsService;
import ru.yandex.autotests.mediaplan.services.sitelinks.SitelinksService;
import ru.yandex.autotests.mediaplan.services.vcards.VcardsService;

/**
 * Changes by ginger on 17.02.16.
 */
public enum ServiceNames {
    AD_GROUPS(AdGroupsService.SERVICE_NAME, AdGroupsService.class),
    ADS(AdsService.SERVICE_NAME, AdsService.class),
    BIDS(BidsService.SERVICE_NAME, BidsService.class),
    KEYWORDS(KeywordsService.SERVICE_NAME, KeywordsService.class),
    MEDIAPLANS(MediaplansService.SERVICE_NAME, MediaplansService.class),
    REQUESTS(RequestsService.SERVICE_NAME, RequestsService.class),
    SITELINKS(SitelinksService.SERVICE_NAME, SitelinksService.class),
    VCARDS(VcardsService.SERVICE_NAME, VcardsService.class),
    CHANGES(ChangesService.SERVICE_NAME, ChangesService.class);

    private final String serviceName;

    private final Class serviceMethods;

    ServiceNames(String action, Class methods) {
        this.serviceName = action;
        this.serviceMethods = methods;
    }

    public Class getMethodsClass(){
        return this.serviceMethods;
    }

    @Override
    public String toString(){
        return this.serviceName;
    }
}
