package ru.yandex.autotests.mediaplan.datafactories;

import org.apache.commons.lang3.RandomStringUtils;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.AdGroup;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.NegativeKeywords;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_adgroups.ParamsApi5AddAdgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AddAdGroupsFactory {
    public static final Long REGION = 213l;
    public static final String NAME = "name";

    private AddAdGroupsFactory(){}

    public static ParamsApi5AddAdgroups oneAdgroup() {
        ParamsApi5AddAdgroups addAdGroupsInputData = new ParamsApi5AddAdgroups().withAdGroups(
                Collections.singletonList(oneAdgroupElement())
        );
        return addAdGroupsInputData;
    }

    public static ParamsApi5AddAdgroups oneAdgroupWithLongName() {
        ParamsApi5AddAdgroups addAdGroupsInputData = new ParamsApi5AddAdgroups().withAdGroups(
                Collections.singletonList(oneAdgroupElement().withName(RandomStringUtils.randomAlphabetic(256)))
        );
        return addAdGroupsInputData;
    }

    public static ParamsApi5AddAdgroups twoSameAdgroups() {
        List<AdGroup> addAdGroupsInputItems = new ArrayList<AdGroup>();
        addAdGroupsInputItems.add(oneAdgroupElement());
        addAdGroupsInputItems.add(oneAdgroupElement());
        ParamsApi5AddAdgroups addAdGroupsInputData = new ParamsApi5AddAdgroups().withAdGroups(addAdGroupsInputItems);
        return addAdGroupsInputData;
    }

    public static ParamsApi5AddAdgroups twoRandomAdgroups() {
        return nRandomGroups(2);
    }

    public static ParamsApi5AddAdgroups thousandRandomAdgroups() {
        return nRandomGroups(1000);
    }

    public static ParamsApi5AddAdgroups tooMuchRandomAdgroups() {
        return nRandomGroups(1001);
    }

    private static ParamsApi5AddAdgroups nRandomGroups(int n) {
        List<AdGroup> addAdGroupsInputItems = new ArrayList<>(n);
        for (int i = 0; i < n; i++) {
            addAdGroupsInputItems.add(i,
                    new AdGroup()
                            .withRegionIds(Collections.singletonList(RegionIDValues.getRandomId().longValue()))
                                            .withName(RandomStringUtils.randomAlphabetic(8))
                            );
        }
        return new ParamsApi5AddAdgroups()
                .withAdGroups(addAdGroupsInputItems);

    }

    public static ParamsApi5AddAdgroups oneAdgroupWithOptionalParams() {
        ParamsApi5AddAdgroups addAdGroupsInputData = new ParamsApi5AddAdgroups().withAdGroups(
                Collections.singletonList(new AdGroup().withRegionIds(Collections.singletonList(REGION)).withName(NAME).withDirectAdGroupId(6L)
                .withNegativeKeywords(new NegativeKeywords().withItems(Collections.singletonList("word"))))
        );
        return addAdGroupsInputData;
    }

    public static ParamsApi5AddAdgroups twoAdgroupWithOptionalParams() {
        List<AdGroup> addAdGroupsInputItems = new ArrayList<>(2);
        addAdGroupsInputItems.add(new AdGroup().withRegionIds(Collections.singletonList(REGION)).withName(NAME).withDirectAdGroupId(122L));
        addAdGroupsInputItems.add(new AdGroup().withRegionIds(Collections.singletonList(REGION)).withName(NAME).withDirectAdGroupId(122L));
        ParamsApi5AddAdgroups addAdGroupsInputData = new ParamsApi5AddAdgroups().withAdGroups(addAdGroupsInputItems);
        return addAdGroupsInputData;
    }

    public static ParamsApi5AddAdgroups twoAdgroupHalfWithOptionalParams() {
        List<AdGroup> addAdGroupsInputItems = new ArrayList<>(2);
        addAdGroupsInputItems.add(new AdGroup().withRegionIds(Collections.singletonList(REGION)).withName(NAME).withDirectAdGroupId(122L));
        addAdGroupsInputItems.add(new AdGroup().withRegionIds(Collections.singletonList(REGION)).withName(NAME));
        ParamsApi5AddAdgroups addAdGroupsInputData = new ParamsApi5AddAdgroups().withAdGroups(addAdGroupsInputItems);
        return addAdGroupsInputData;
    }

    private static AdGroup oneAdgroupElement() {
        return new AdGroup().withRegionIds(Collections.singletonList(REGION)).withName(NAME);
    }
}
