package ru.yandex.autotests.mediaplan.datafactories;

import org.apache.commons.lang3.RandomStringUtils;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.Ad;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.ParamsApi5AddAds;
import ru.yandex.autotests.mediaplan.datacontainersauto.api5_add_ads.TextAd;

import java.util.ArrayList;
import java.util.List;

public class AddAdsFactory {
    public static final TextAd TEXT_AD = new TextAd().withText("text").withTitle("title");
    private AddAdsFactory(){}
    public static ParamsApi5AddAds oneAd() {
        return new ParamsApi5AddAds().withAds(nAdds(1));
    }
    public static ParamsApi5AddAds twoAd() {
        return new ParamsApi5AddAds().withAds(nAdds(2));
    }


    public static ParamsApi5AddAds fiftyAd() {
        return new ParamsApi5AddAds().withAds(nAdds(50));
    }

    public static ParamsApi5AddAds thousandAd() {
        return new ParamsApi5AddAds().withAds(nAdds(1000));
    }

    public static ParamsApi5AddAds fiftyOneAd() {
        return new ParamsApi5AddAds().withAds(nAdds(51));
    }
    public static ParamsApi5AddAds fiftyCorrectAndOneIncorrectAd() {
        ParamsApi5AddAds result = new ParamsApi5AddAds().withAds(nAdds(51));
        result.getAds().get(0).setTextAd(new TextAd().withText(RandomStringUtils.random(8096)).withTitle(""));
        return result;
    }
    public static ParamsApi5AddAds OneCorrectAndOneIncorrectAd() {
        ParamsApi5AddAds result = new ParamsApi5AddAds().withAds(nAdds(2));
        result.getAds().get(0).setTextAd(new TextAd().withText(RandomStringUtils.random(8096)).withTitle(""));
        return result;
    }

    private static List<Ad> nAdds(int n) {
        List<Ad> ads = new ArrayList<>();
        for (int i = 0; i < n; i ++) {
            ads.add(oneAdElement());
        }
        return ads;
    }
    private static Ad oneAdElement() {
        return new Ad().withTextAd(TEXT_AD);
    }
}
